/**
    JEM, the BEE - Job Entry Manager, the Batch Execution Environment
    Copyright (C) 2012, 2013   Andrea "Stock" Stocchero
    This program is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program.  If not, see <http://www.gnu.org/licenses/>.
*/
package org.pepstock.jem.util;

import org.apache.commons.lang3.StringUtils;
import org.pepstock.jem.util.filters.ParseException;

/**
 * @author Andrea "Stock" Stocchero
 * @version 1.0	
 *
 */
public class TimeUtils {
	
	private TimeUtils() {
	}
	
	/**
	 * 
	 */
	public static final long SECOND = 1000;
	
	/**
	 * 
	 */
	public static final long MINUTE = SECOND * 60;
	
	/**
	 * 
	 */
	public static final long HOUR = MINUTE * 60;
	
	/**
	 * 
	 */
	public static final long DAY = HOUR * 24;

	/**
	 * 
	 */
	public static final String D_STRING = "d";
	
	/**
	 * 
	 */
	public static final String H_STRING = "h";
	
	/**
	 * 
	 */
	public static final String M_STRING = "m";
	
	/**
	 * 
	 */
	public static final char D = 'd';
	
	/**
	 * 
	 */
	public static final char H = 'h';
	
	/**
	 * 
	 */
	public static final char M = 'm';
	
	/**
	 * Returns the milliseconds corrisponding to a string in the format:
	 * - [0-9]+[d|h|m]
	 * like:
	 * - 2d (two days) or
	 * - 3h (three hours) or
	 * - 15m (fifteen minutes)
	 * and so on.
	 * 
	 * @param tokenValue the value to be parsed
	 * @return the milliseconds identified by parameter
	 * @throws ParseException if the parameter cannot be parsed
	 */
	public static long parseDuration(String tokenValue) throws ParseException {
		// validate the value!
		if (!(StringUtils.endsWithIgnoreCase(tokenValue, D_STRING) 
				|| StringUtils.endsWithIgnoreCase(tokenValue, H_STRING) 
				|| StringUtils.endsWithIgnoreCase(tokenValue, M_STRING))) {
			throw new ParseException("Invalid time unit!");
		}
		
		// parse the date value
		int timeUnitIndex = tokenValue.length()-1;
		char timeUnit = tokenValue.charAt(timeUnitIndex);
		int timeValue;
		try {
			timeValue = Integer.parseInt(tokenValue.substring(0, timeUnitIndex));
		} catch (Exception e) {
			throw new ParseException("Invalid time value!");
		}

		long time;
		switch (timeUnit) {
			case D:
				time = timeValue * DAY;
				break;
			case H:
				time = timeValue * HOUR;
				break;
			case M:
				time = timeValue * MINUTE;
				break;
			default:
				throw new ParseException("Invalid time unit!");
		}

		return time;
	}
	
}