/**
    JEM, the BEE - Job Entry Manager, the Batch Execution Environment
    Copyright (C) 2012, 2013   Simone "Busy" Businaro
    This program is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program.  If not, see <http://www.gnu.org/licenses/>.
*/
package org.pepstock.jem.quartz;

import java.util.ArrayList;
import java.util.List;

import org.pepstock.jem.commands.LocalHostSubmit;
import org.pepstock.jem.commands.SubmitResult;
import org.pepstock.jem.node.NodeMessage;
import org.quartz.Job;
import org.quartz.JobExecutionContext;
import org.quartz.JobExecutionException;

/**
 * @author Simone "Busy" Businaro
 * @version 1.0
 * 
 *          This class represent a Quartz Job to execute the jem command
 *          LocalHostSubmit.
 * @see org.pepstock.jem.commands.LocalHostSubmit
 */
public class JobLocalHostSubmit implements Job {

	private String jemEnv = null;

	private String password = null;

	private String jemPort = null;

	private String jclUrl = null;

	private String jclType = null;

	private boolean noWait = false;

	private String privateKeyFile = null;

	private String privateKeyPwd = null;

	/*
	 * (non-Javadoc)
	 * 
	 * @see org.quartz.Job#execute(org.quartz.JobExecutionContext)
	 */
	@Override
	public void execute(JobExecutionContext context) throws JobExecutionException {
		SubmitResult sr = LocalHostSubmit.executeCommand(createArgs());
		if (sr.getRc() != 0) {
			throw new JobExecutionException(NodeMessage.JEMC021I.toMessage().getFormattedMessage("", sr.getRc()));
		}
	}

	/**
	 * 
	 * @return the arguments needed to start LocalHostSubmit
	 */
	private String[] createArgs() {
		List<String> list = new ArrayList<String>();
		if (jemEnv != null) {
			list.add("-" + LocalHostSubmit.ENV);
			list.add(jemEnv);
		}
		if (password != null) {
			list.add("-" + LocalHostSubmit.PASSWORD);
			list.add(password);
		}
		if (jemPort != null) {
			list.add("-" + LocalHostSubmit.PORT);
			list.add(jemPort);
		}
		if (jclUrl != null) {
			list.add("-" + LocalHostSubmit.JCL);
			list.add(jclUrl);
		}
		if (jclType != null) {
			list.add("-" + LocalHostSubmit.TYPE);
			list.add(jclType);
		}
		if (privateKeyFile != null) {
			list.add("-" + LocalHostSubmit.PRIVATE_KEY);
			list.add(privateKeyFile);
		}
		if (privateKeyPwd != null) {
			list.add("-" + LocalHostSubmit.PRIVATE_KEY_PWD);
			list.add(privateKeyPwd);
		}
		if (noWait) {
			list.add("-" + LocalHostSubmit.NOWAIT);
		}
		return list.toArray(new String[list.size()]);
	}

	/**
	 * @param jemEnv the jemEnv to set.
	 *            <p>
	 *            It is called by quartz framework before the execute method but
	 *            JobDetail must include this property: e.g.
	 *            <p>
	 *            JobDetail job = JobBuilder.newJob(JobLocalHostSubmit.class)<br>
	 *            .withIdentity("job1", "group1")<br>
	 *            <b>.usingJobData("jemEnv", "C0-CRM")</b><br>
	 *            .usingJobData("jemPort", "5710")<br>
	 *            .usingJobData("jclUrl",
	 *            "file:/C:/Users/Simone/Desktop/JEM/test/ECHO.xml")<br>
	 *            .usingJobData("jclType", "ant")<br>
	 *            .build();<br>
	 */
	public void setJemEnv(String jemEnv) {
		this.jemEnv = jemEnv;
	}

	/**
	 * @param jemPort the jemPort to set.
	 *            <p>
	 *            It is called by quartz framework before the execute method but
	 *            JobDetail must include this property: e.g.
	 *            <p>
	 *            JobDetail job = JobBuilder.newJob(JobLocalHostSubmit.class)<br>
	 *            .withIdentity("job1", "group1")<br>
	 *            .usingJobData("jemEnv", "C0-CRM")<br>
	 *            <b>.usingJobData("jemPort", "5710")</b><br>
	 *            .usingJobData("jclUrl",
	 *            "file:/C:/Users/Simone/Desktop/JEM/test/ECHO.xml")<br>
	 *            .usingJobData("jclType", "ant")<br>
	 *            .build();<br>
	 */
	public void setJemPort(String jemPort) {
		this.jemPort = jemPort;
	}

	/**
	 * @param jclUrl the jclUrl to set.
	 *            <p>
	 *            It is called by quartz framework before the execute method but
	 *            JobDetail must include this property: e.g.
	 *            <p>
	 *            JobDetail job = JobBuilder.newJob(JobLocalHostSubmit.class)<br>
	 *            .withIdentity("job1", "group1")<br>
	 *            .usingJobData("jemEnv", "C0-CRM")<br>
	 *            .usingJobData("jemPort", "5710")<br>
	 *            <b>.usingJobData("jclUrl",
	 *            "file:/C:/Users/Simone/Desktop/JEM/test/ECHO.xml")</b><br>
	 *            .usingJobData("jclType", "ant")<br>
	 *            .build();<br>
	 */
	public void setJclUrl(String jclUrl) {
		this.jclUrl = jclUrl;
	}

	/**
	 * @param jclType the jclType to set.
	 *            <p>
	 *            It is called by quartz framework before the execute method but
	 *            JobDetail must include this property: e.g.
	 *            <p>
	 *            JobDetail job = JobBuilder.newJob(JobLocalHostSubmit.class)<br>
	 *            .withIdentity("job1", "group1")<br>
	 *            .usingJobData("jemEnv", "C0-CRM")<br>
	 *            .usingJobData("jemPort", "5710")<br>
	 *            .usingJobData("jclUrl",
	 *            "file:/C:/Users/Simone/Desktop/JEM/test/ECHO.xml")<br>
	 *            <b>.usingJobData("jclType", "ant")</b><br>
	 *            .build();<br>
	 */
	public void setJclType(String jclType) {
		this.jclType = jclType;
	}

	/**
	 * @param noWait the noWait to set, default is false.
	 *            <p>
	 *            It is called by quartz framework before the execute method but
	 *            JobDetail must include this property: e.g.
	 *            <p>
	 *            JobDetail job = JobBuilder.newJob(JobLocalHostSubmit.class)<br>
	 *            .withIdentity("job1", "group1")<br>
	 *            .usingJobData("jemEnv", "C0-CRM")<br>
	 *            <b>.usingJobData("noWait", "true")</b><br>
	 *            .usingJobData("jemPort", "5710")<br>
	 *            .usingJobData("jclUrl",
	 *            "file:/C:/Users/Simone/Desktop/JEM/test/ECHO.xml")<br>
	 *            .usingJobData("jclType", "ant")<br>
	 *            .build();<br>
	 */
	public void setNoWait(boolean noWait) {
		this.noWait = noWait;
	}

	/**
	 * @param password the password to set
	 */
	public void setPassword(String password) {
		this.password = password;
	}

	/**
	 * @param privateKeyFile the privateKeyFile to set
	 */
	public void setPrivateKeyFile(String privateKeyFile) {
		this.privateKeyFile = privateKeyFile;
	}

	/**
	 * @param privateKeyPwd the privateKeyPwd to set
	 */
	public void setPrivateKeyPwd(String privateKeyPwd) {
		this.privateKeyPwd = privateKeyPwd;
	}

}