/**
    JEM, the BEE - Job Entry Manager, the Batch Execution Environment
    Copyright (C) 2012, 2013   Simone "Busy" Businaro
    This program is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program.  If not, see <http://www.gnu.org/licenses/>.
*/
package org.pepstock.jem.quartz;

import java.util.ArrayList;
import java.util.List;

import org.pepstock.jem.commands.HttpSubmit;
import org.pepstock.jem.node.NodeMessage;
import org.quartz.Job;
import org.quartz.JobExecutionContext;
import org.quartz.JobExecutionException;

/**
 * @author Simone "Busy" Businaro
 * @version 1.0
 * 
 *          This class represent a Quartz Job to execute the jem command
 *          HttpSubmit.
 * @see org.pepstock.jem.commands.HttpSubmit
 */
public class JobHttpSubmit implements Job {

	private String jclUrl = null;

	private String jclType = null;

	private String hostForJemWeb = null;

	private String passwordValue = null;

	private String userValue = null;

	/*
	 * (non-Javadoc)
	 * 
	 * @see org.quartz.Job#execute(org.quartz.JobExecutionContext)
	 */
	@Override
	public void execute(JobExecutionContext arg0) throws JobExecutionException {
		int rc = HttpSubmit.executeCommand(createArgs());
		if (rc != 0) {
			throw new JobExecutionException(NodeMessage.JEMC021I.toMessage().getFormattedMessage("", rc));
		}
	}

	/**
	 * 
	 * @return the arguments needed to start LocalHostSubmit
	 */
	private String[] createArgs() {
		List<String> list = new ArrayList<String>();
		if (jclUrl != null) {
			list.add("-" + HttpSubmit.JCL);
			list.add(jclUrl);
		}
		if (jclType != null) {
			list.add("-" + HttpSubmit.TYPE);
			list.add(jclType);
		}
		if (hostForJemWeb != null) {
			list.add("-" + HttpSubmit.HOST);
			list.add(hostForJemWeb);
		}
		if (passwordValue != null) {
			list.add("-" + HttpSubmit.PASSWORD);
			list.add(passwordValue);
		}
		if (userValue != null) {
			list.add("-" + HttpSubmit.USER);
			list.add(userValue);
		}
		return list.toArray(new String[list.size()]);
	}

	/**
	 * @param jclUrl the jclUrl to set
	 *            <p>
	 *            It is called by quartz framework before the execute method but
	 *            JobDetail must include this property: e.g.
	 *            <p>
	 *            JobDetail job = JobBuilder.newJob(HttpSubmit.class)<br>
	 *            .withIdentity("job1", "group1")<br>
	 *            <b>.usingJobData("jclUrl",
	 *            "file:/C:/Users/Simone/Desktop/JEM/test/ECHO.xml")</b><br>
	 *            .build();<br>
	 */
	public void setJclUrl(String jclUrl) {
		this.jclUrl = jclUrl;
	}

	/**
	 * @param jclType the jclType to set
	 *            <p>
	 *            It is called by quartz framework before the execute method but
	 *            JobDetail must include this property: e.g.
	 *            <p>
	 *            JobDetail job = JobBuilder.newJob(HttpSubmit.class)<br>
	 *            .withIdentity("job1", "group1")<br>
	 *            <b>.usingJobData("jclType","ant")</b><br>
	 *            .build();<br>
	 */
	public void setJclType(String jclType) {
		this.jclType = jclType;
	}

	/**
	 * @param hostForJemWeb the hostForJemWeb to set
	 *            <p>
	 *            It is called by quartz framework before the execute method but
	 *            JobDetail must include this property: e.g.
	 *            <p>
	 *            JobDetail job = JobBuilder.newJob(HttpSubmit.class)<br>
	 *            .withIdentity("job1", "group1")<br>
	 *            <b>.usingJobData("hostForJemWeb",
	 *            "http://localhost:8080/jem_gwt")</b><br>
	 *            .build();<br>
	 */
	public void setHostForJemWeb(String hostForJemWeb) {
		this.hostForJemWeb = hostForJemWeb;
	}

	/**
	 * @param passwordValue the passwordValue to set
	 *            <p>
	 *            It is called by quartz framework before the execute method but
	 *            JobDetail must include this property: e.g.
	 *            <p>
	 *            JobDetail job = JobBuilder.newJob(HttpSubmit.class)<br>
	 *            .withIdentity("job1", "group1")<br>
	 *            <b>.usingJobData("passwordValue","password")</b><br>
	 *            .build();<br>
	 */
	public void setPasswordValue(String passwordValue) {
		this.passwordValue = passwordValue;
	}

	/**
	 * @param userValue the userValue to set
	 *            <p>
	 *            It is called by quartz framework before the execute method but
	 *            JobDetail must include this property: e.g.
	 *            <p>
	 *            JobDetail job = JobBuilder.newJob(HttpSubmit.class)<br>
	 *            .withIdentity("job1", "group1")<br>
	 *            <b>.usingJobData("userValue","username")</b><br>
	 *            .build();<br>
	 */
	public void setUserValue(String userValue) {
		this.userValue = userValue;
	}

}