/**
    JEM, the BEE - Job Entry Manager, the Batch Execution Environment
    Copyright (C) 2012, 2013   Andrea "Stock" Stocchero
    This program is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program.  If not, see <http://www.gnu.org/licenses/>.
*/
package org.pepstock.jem.node.tasks.platform;

import org.apache.commons.lang3.SystemUtils;

/**
 * Singleton class to set the current platform where JEM node is running
 * 
 * @author Andrea "Stock" Stocchero
 * @version 1.3	
 *
 */
public class CurrentPlatform {
	
	private static Platform INSTANCE = null;

	/**
	 * Contruct the platform object by the OS where is running
	 * 
	 * @throws Exception if OS is not supported, an exception occurs
	 */
	private CurrentPlatform() throws Exception {
		if (SystemUtils.IS_OS_UNIX){
			INSTANCE = new UnixPlatform();
		} else if (SystemUtils.IS_OS_WINDOWS){
			INSTANCE = new WindowsPlatform();
		} else throw new Exception(SystemUtils.OS_NAME+" is not supported");
	}

	
	/**
	 * Singleton method to get the current platform
	 * 
	 * @return platform instance
	 * 
	 * @throws Exception if OS is not supported, an exception occurs
	 */
	public static final Platform getInstance() throws Exception{
		if (INSTANCE == null){
			new CurrentPlatform();
		}
		return INSTANCE;
	}
}