/**
    JEM, the BEE - Job Entry Manager, the Batch Execution Environment
    Copyright (C) 2012, 2013   Andrea "Stock" Stocchero
    This program is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program.  If not, see <http://www.gnu.org/licenses/>.
*/
package org.pepstock.jem.node.tasks.platform;

import java.util.ArrayList;

import org.hyperic.sigar.ProcState;
import org.hyperic.sigar.Sigar;
import org.hyperic.sigar.SigarException;

/**
 * Abstract representation of platform.
 * 
 * @author Andrea "Stock" Stocchero
 * @version 1.3	
 *
 */
public abstract class AbstractPlatform implements Platform {
	
	/**
	 * Gets whole chain of processes starting from a process ID.
	 *  
	 * @param pid parent process ID
	 * @return collections od processes ID
	 */
	public ArrayList<Long> getProcessesChain(long pid){
		Sigar sigar = new Sigar();
		ArrayList<Long> processes= new ArrayList<Long>();
		processes.add(pid);
		try {
			long[] allProcessesId = sigar.getProcList();
			 loadChildProcessId(pid, allProcessesId, processes, sigar);
		} catch (SigarException e) {
		}
		return processes;
	}
	/**
	 * Gets child process search inside of an array of processes ID by Sigar. If there isn't any child, return -1L
	 * @param parentId parent process ID
	 * @param allProcessesId array with all Process ID
	 */
	private void loadChildProcessId(long parentId, long[] allProcessesId, ArrayList<Long> processes, Sigar sigar){
		for (long processId : allProcessesId){
			ProcState state;
			try {
				state = sigar.getProcState(processId);
				if (state.getPpid() == parentId){
					processes.add(processId);
					loadChildProcessId(processId, allProcessesId, processes, sigar);
				}
			} catch (SigarException e) {
			}
		}
	}
}