/**
    JEM, the BEE - Job Entry Manager, the Batch Execution Environment
    Copyright (C) 2012, 2013   Andrea "Stock" Stocchero
    This program is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program.  If not, see <http://www.gnu.org/licenses/>.
*/
package org.pepstock.jem.node.tasks.jndi;

import java.util.Hashtable;

import javax.naming.Context;
import javax.naming.Name;
import javax.naming.RefAddr;
import javax.naming.Reference;
import javax.naming.spi.ObjectFactory;

import org.apache.commons.lang3.StringUtils;
import org.jppf.utils.TypedProperties;
import org.pepstock.jem.jppf.JPPFMessage;
import org.pepstock.jem.jppf.Keys;
import org.pepstock.jem.node.resources.JppfResource;

/**
 * JNDI factory to create typedProperties to lod on JPPFConfiguration
 *  
 * @author Andrea "Stock" Stocchero
 * @version 1.4
 * 
 */
public class JppfFactory implements ObjectFactory {

	/**
	 * 
	 */
	@Override
	public Object getObjectInstance(Object obj, Name name, Context nameCtx, @SuppressWarnings("rawtypes") Hashtable environment) throws Exception {

		if ((obj == null) || !(obj instanceof Reference)) {
			return null;
		}

		String addresses = null;
		Reference ref = (Reference) obj;
		RefAddr ra = ref.get(JppfResource.ADDRESSES);
		if (ra != null) {
			addresses = ra.getContent().toString().trim();
		} else {
			throw new Exception(JPPFMessage.JEMJ009E.toMessage().getFormattedMessage(JppfResource.ADDRESSES));
		}
		return createTypeProperties(addresses);
	}

	/**
	 * Creates a typed properties parsing the addresses, comma separated
	 * 
	 * @param address list addresses comma separated
	 * @return typed propertiss for JPPF connection
	 * @throws Exception if an error occurs 
	 */
	public static Object createTypeProperties(String address) throws Exception {
		TypedProperties props = new TypedProperties();
		
		/*----------------------+
		 | Load JPPF properties | 
		 +----------------------*/
		props.setProperty(Keys.JEM_JPPF_DISCOVERY_ENABLED, Boolean.FALSE.toString());
	
		if (address != null){
			address = StringUtils.remove(address, " ");
			String[] addresses = StringUtils.split(address, ",");
			if (addresses != null){
				if (addresses.length > 0){
					StringBuffer drivers = new StringBuffer();
					for (int i=0; i<addresses.length; i++){
						if (addresses[i].contains(":")){
							String host = StringUtils.substringBefore(addresses[i], ":");
							String port = StringUtils.substringAfter(addresses[i], ":");
							String driver = Keys.JEM_JPPF_DRIVER_PREFIX+i;
							
							props.setProperty(driver+Keys.JEM_JPPF_PORT_SUFFIX, port);
							props.setProperty(driver+Keys.JEM_JPPF_SERVER_SUFFIX, host);
							
							drivers.append(driver).append(" ");
						} else {
							throw new Exception(JPPFMessage.JEMJ008E.toMessage().getFormattedMessage(addresses[i]));			
						}
					}
					props.setProperty(Keys.JEM_JPPF_DRIVERS, drivers.toString());
				}
			}
		}
		return props;
	}
}