/**
    JEM, the BEE - Job Entry Manager, the Batch Execution Environment
    Copyright (C) 2012, 2013   InigoSurguy
    This program is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program.  If not, see <http://www.gnu.org/licenses/>.
*/
package org.pepstock.jem.node.tasks.jndi;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;

/**
 * An invocation handler that calls directly the method of delegate oject.
 * Works ONLY on public methods.
 * 
 * @author Andrea Stock Stocchero
 * @version 1.0
 */
class DelegateInvocationHandler implements InvocationHandler {
	private final Object delegate;

	public DelegateInvocationHandler(Object delegate) {
		this.delegate = delegate;
	}

	public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
		Method delegateMethod = delegate.getClass().getMethod(method.getName(), method.getParameterTypes());
		return delegateMethod.invoke(delegate, args);
	}
}