/**
    JEM, the BEE - Job Entry Manager, the Batch Execution Environment
    Copyright (C) 2012, 2013   Andrea "Stock" Stocchero
    This program is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program.  If not, see <http://www.gnu.org/licenses/>.
*/
package org.pepstock.jem.node.tasks;

/**
 * Enumeration with the list of folder to include on classpath of process, launched to execute the job.<br>
 * This has been done because the environment variables are a limit of 8k and command line of 2k.<br>
 * Furthermore it seems that ANT is not able to use classpath wildcard. 
 * 
 * @author Andrea "Stock" Stocchero
 * @version 1.4
 */
public enum Libraries {
	
	CLI("cli"),
	COMMONS_CODEC("commons-codec"),
	COMMONS_IO("commons-io"),
	COMMONS_NET("commons-net"),
//	DB("db"),
	DBCP("dbcp"),
	EXT("ext"),
	HTTPCOMPONENTS("httpcomponents"),
	JMS("jms"),
	JPPF("jppf"),
	LANG("lang"),
	LOGGING("logging"),
	SHIRO("shiro"),
	XALAN("xalan"),
	XSTREAM("xstream");
	
	private String path = null;
	
	private Libraries(String path) {
		this.path = path;
	}
	
	/**
	 * @return the path to check
	 */
	public String getPath(){
		return path;
	}
}