/**
    JEM, the BEE - Job Entry Manager, the Batch Execution Environment
    Copyright (C) 2012, 2013   Andrea "Stock" Stocchero
    This program is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program.  If not, see <http://www.gnu.org/licenses/>.
*/
package org.pepstock.jem.node.stats;

import java.io.Serializable;
import java.util.HashMap;

/**
 * @author Andrea "Stock" Stocchero
 * @version 1.0
 * 
 */
public class MemberSample implements Serializable {

	private static final long serialVersionUID = 1L;

	private String memberKey = null;

	private String memberLabel = null;
	
	private String memberHostname = null;
	
	private long currentTimeMillis = System.currentTimeMillis(); 

	private long pid = Long.MIN_VALUE;
	
	private long numberOfJCLCheck = Long.MIN_VALUE;
	
	private long numberOfJOBSubmitted = Long.MIN_VALUE;

	private long totalNumberOfJCLCheck = Long.MIN_VALUE;
	
	private long totalNumberOfJOBSubmitted = Long.MIN_VALUE;

	private CpuUtilization cpu = new CpuUtilization();
	
	private MemoryUtilization memory = new MemoryUtilization();

	private ProcessCpuUtilization processCpu = new ProcessCpuUtilization();

	private ProcessMemoryUtilization processMemory = new ProcessMemoryUtilization();
	
	private FileSystemUtilization fileSystem = new FileSystemUtilization();
	
	private HashMap<String, MapStats> mapsStats = new HashMap<String, MapStats>();

	private HashMap<String, QueueStats> queuesStats = new HashMap<String, QueueStats>();
	/**
	 * 
	 */
	public MemberSample() {
	}

	/**
	 * @return the member
	 */
	public String getMemberKey() {
		return memberKey;
	}

	/**
	 * @param member the member to set
	 */
	public void setMemberKey(String member) {
		this.memberKey = member;
	}

	/**
	 * @return the memberLabel
	 */
	public String getMemberLabel() {
		return memberLabel;
	}

	/**
	 * @param memberLabel the memberLabel to set
	 */
	public void setMemberLabel(String memberLabel) {
		this.memberLabel = memberLabel;
	}

	/**
	 * @return the memberHostname
	 */
	public String getMemberHostname() {
		return memberHostname;
	}

	/**
	 * @param memberHostname the memberHostname to set
	 */
	public void setMemberHostname(String memberHostname) {
		this.memberHostname = memberHostname;
	}

	
	/**
	 * @return the currentTimeMillis
	 */
	public long getCurrentTimeMillis() {
		return currentTimeMillis;
	}

	/**
	 * @param currentTimeMillis the currentTimeMillis to set
	 */
	public void setCurrentTimeMillis(long currentTimeMillis) {
		this.currentTimeMillis = currentTimeMillis;
	}

	/**
	 * @return the pid
	 */
	public long getPid() {
		return pid;
	}

	/**
	 * @param pid the pid to set
	 */
	public void setPid(long pid) {
		this.pid = pid;
	}

	
	
	/**
	 * @return the numberOfJCLCheck
	 */
	public long getNumberOfJCLCheck() {
		return numberOfJCLCheck;
	}

	/**
	 * @param numberOfJCLCheck the numberOfJCLCheck to set
	 */
	public void setNumberOfJCLCheck(long numberOfJCLCheck) {
		this.numberOfJCLCheck = numberOfJCLCheck;
	}

	/**
	 * @return the numberOfJOBSubmitted
	 */
	public long getNumberOfJOBSubmitted() {
		return numberOfJOBSubmitted;
	}

	/**
	 * @param numberOfJOBSubmitted the numberOfJOBSubmitted to set
	 */
	public void setNumberOfJOBSubmitted(long numberOfJOBSubmitted) {
		this.numberOfJOBSubmitted = numberOfJOBSubmitted;
	}

	/**
	 * @return the totalNumberOfJCLCheck
	 */
	public long getTotalNumberOfJCLCheck() {
		return totalNumberOfJCLCheck;
	}

	/**
	 * @param totalNumberOfJCLCheck the totalNumberOfJCLCheck to set
	 */
	public void setTotalNumberOfJCLCheck(long totalNumberOfJCLCheck) {
		this.totalNumberOfJCLCheck = totalNumberOfJCLCheck;
	}

	/**
	 * @return the totalNumberOfJOBSubmitted
	 */
	public long getTotalNumberOfJOBSubmitted() {
		return totalNumberOfJOBSubmitted;
	}

	/**
	 * @param totalNumberOfJOBSubmitted the totalNumberOfJOBSubmitted to set
	 */
	public void setTotalNumberOfJOBSubmitted(long totalNumberOfJOBSubmitted) {
		this.totalNumberOfJOBSubmitted = totalNumberOfJOBSubmitted;
	}

	/**
	 * @return the cpu
	 */
	public CpuUtilization getCpu() {
		return cpu;
	}

	/**
	 * @param cpu the cpu to set
	 */
	public void setCpu(CpuUtilization cpu) {
		this.cpu = cpu;
	}

	/**
	 * @return the processCpu
	 */
	public ProcessCpuUtilization getProcessCpu() {
		return processCpu;
	}

	/**
	 * @param processCpu the processCpu to set
	 */
	public void setProcessCpu(ProcessCpuUtilization processCpu) {
		this.processCpu = processCpu;
	}

	/**
	 * @return the processMemory
	 */
	public ProcessMemoryUtilization getProcessMemory() {
		return processMemory;
	}

	/**
	 * @param processMemory the processMemory to set
	 */
	public void setProcessMemory(ProcessMemoryUtilization processMemory) {
		this.processMemory = processMemory;
	}

	/**
	 * @return the memory
	 */
	public MemoryUtilization getMemory() {
		return memory;
	}

	/**
	 * @param memory the memory to set
	 */
	public void setMemory(MemoryUtilization memory) {
		this.memory = memory;
	}

	
	
	/**
	 * @return the mapsStats
	 */
	public HashMap<String, MapStats> getMapsStats() {
		return mapsStats;
	}

	/**
	 * @param mapsStats the mapsStats to set
	 */
	public void setMapsStats(HashMap<String, MapStats> mapsStats) {
		this.mapsStats = mapsStats;
	}

	
	/**
	 * @return the queuesStats
	 */
	public HashMap<String, QueueStats> getQueuesStats() {
		return queuesStats;
	}

	/**
	 * @param queuesStats the queuesStats to set
	 */
	public void setQueuesStats(HashMap<String, QueueStats> queuesStats) {
		this.queuesStats = queuesStats;
	}

	
	/**
	 * @return the fileSystem
	 */
	public FileSystemUtilization getFileSystem() {
		return fileSystem;
	}

	/**
	 * @param fileSystem the fileSystem to set
	 */
	public void setFileSystem(FileSystemUtilization fileSystem) {
		this.fileSystem = fileSystem;
	}

	/* (non-Javadoc)
	 * @see java.lang.Object#toString()
	 */
	@Override
	public String toString() {
		return "MemberSample [memberKey=" + memberKey + ", memberLabel=" + memberLabel + ", pid=" + pid + ", numberOfJCLCheck=" + numberOfJCLCheck + ", numberOfJOBSubmitted=" + numberOfJOBSubmitted + ", cpu=" + cpu 
				+ ", memory=" + memory + ", processCpu=" + processCpu + ", processMemory=" + processMemory + ", mapsStats=" + mapsStats + ", queuesStats=" + queuesStats + "]";
	}

}