/**
    JEM, the BEE - Job Entry Manager, the Batch Execution Environment
    Copyright (C) 2012, 2013   Andrea "Stock" Stocchero
    This program is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program.  If not, see <http://www.gnu.org/licenses/>.
*/
package org.pepstock.jem.node.stats;

import java.io.Serializable;
import java.util.HashMap;

/**
 * @author Andrea "Stock" Stocchero
 * @version 1.0
 * 
 */
public class LightMemberSample implements Serializable {

	private static final long serialVersionUID = 1L;

	private String memberKey = null;

	private String memberLabel = null;

	private String memberHostname = null;
	
	private long pid = Long.MIN_VALUE;
	
	private String key = null;
	
	private String time = null;
	
	private long numberOfJCLCheck = 0;
	
	private long numberOfJOBSubmitted = 0;

	private long totalNumberOfJCLCheck = 0;
	
	private long totalNumberOfJOBSubmitted = 0;
	
	private double cpuPercent = 0;
	
	private long memoryAvailable = 0;
	
	private long memoryFree = 0;
	
	private double processCpuPercent = 0;
	
	private long processTotalCpu = 0;
	
	private long processMemoryUsed = 0;

	private long processMemoryFree = 0;
	
	private long gfsUsed = 0;
	
	private long gfsFree = 0;

	private HashMap<String, LightMapStats> mapsStats = new HashMap<String, LightMapStats>();
	
	private HashMap<String, LightMapStats> internalMapsStats = new HashMap<String, LightMapStats>();
	/**
	 * 
	 */
	public LightMemberSample() {
	}
	
	/**
	 * @return the key
	 */
	public String getKey() {
		return key;
	}


	/**
	 * @param key the key to set
	 */
	public void setKey(String key) {
		this.key = key;
	}


	/**
	 * @return the time
	 */
	public String getTime() {
		return time;
	}


	/**
	 * @param time the time to set
	 */
	public void setTime(String time) {
		this.time = time;
	}


	/**
	 * @return the memberKey
	 */
	public String getMemberKey() {
		return memberKey;
	}
	/**
	 * @param memberKey the memberKey to set
	 */
	public void setMemberKey(String memberKey) {
		this.memberKey = memberKey;
	}
	/**
	 * @return the memberLabel
	 */
	public String getMemberLabel() {
		return memberLabel;
	}
	/**
	 * @param memberLabel the memberLabel to set
	 */
	public void setMemberLabel(String memberLabel) {
		this.memberLabel = memberLabel;
	}
	
	/**
	 * @return the memberHostname
	 */
	public String getMemberHostname() {
		return memberHostname;
	}

	/**
	 * @param memberHostname the memberHostname to set
	 */
	public void setMemberHostname(String memberHostname) {
		this.memberHostname = memberHostname;
	}

	/**
	 * @return the pid
	 */
	public long getPid() {
		return pid;
	}
	/**
	 * @param pid the pid to set
	 */
	public void setPid(long pid) {
		this.pid = pid;
	}
	/**
	 * @return the numberOfJCLCheck
	 */
	public long getNumberOfJCLCheck() {
		return numberOfJCLCheck;
	}
	/**
	 * @param numberOfJCLCheck the numberOfJCLCheck to set
	 */
	public void setNumberOfJCLCheck(long numberOfJCLCheck) {
		this.numberOfJCLCheck = numberOfJCLCheck;
	}
	/**
	 * @return the numberOfJOBSubmitted
	 */
	public long getNumberOfJOBSubmitted() {
		return numberOfJOBSubmitted;
	}
	/**
	 * @param numberOfJOBSubmitted the numberOfJOBSubmitted to set
	 */
	public void setNumberOfJOBSubmitted(long numberOfJOBSubmitted) {
		this.numberOfJOBSubmitted = numberOfJOBSubmitted;
	}
	/**
	 * @return the totalNumberOfJCLCheck
	 */
	public long getTotalNumberOfJCLCheck() {
		return totalNumberOfJCLCheck;
	}
	/**
	 * @param totalNumberOfJCLCheck the totalNumberOfJCLCheck to set
	 */
	public void setTotalNumberOfJCLCheck(long totalNumberOfJCLCheck) {
		this.totalNumberOfJCLCheck = totalNumberOfJCLCheck;
	}
	/**
	 * @return the totalNumberOfJOBSubmitted
	 */
	public long getTotalNumberOfJOBSubmitted() {
		return totalNumberOfJOBSubmitted;
	}
	/**
	 * @param totalNumberOfJOBSubmitted the totalNumberOfJOBSubmitted to set
	 */
	public void setTotalNumberOfJOBSubmitted(long totalNumberOfJOBSubmitted) {
		this.totalNumberOfJOBSubmitted = totalNumberOfJOBSubmitted;
	}
	/**
	 * @return the cpuPercent
	 */
	public double getCpuPercent() {
		return cpuPercent;
	}
	/**
	 * @param cpuPercent the cpuPercent to set
	 */
	public void setCpuPercent(double cpuPercent) {
		this.cpuPercent = cpuPercent;
	}
	/**
	 * @return the memoryAvailable
	 */
	public long getMemoryAvailable() {
		return memoryAvailable;
	}
	/**
	 * @param memoryAvailable the memoryAvailable to set
	 */
	public void setMemoryAvailable(long memoryAvailable) {
		this.memoryAvailable = memoryAvailable;
	}
	/**
	 * @return the memoryFree
	 */
	public long getMemoryFree() {
		return memoryFree;
	}
	/**
	 * @param memoryFree the memoryFree to set
	 */
	public void setMemoryFree(long memoryFree) {
		this.memoryFree = memoryFree;
	}
	/**
	 * @return the processCpuPercent
	 */
	public double getProcessCpuPercent() {
		return processCpuPercent;
	}
	/**
	 * @param processCpuPercent the processCpuPercent to set
	 */
	public void setProcessCpuPercent(double processCpuPercent) {
		this.processCpuPercent = processCpuPercent;
	}
	/**
	 * @return the processTotalCpuPercent
	 */
	public long getProcessTotalCpu() {
		return processTotalCpu;
	}
	/**
	 * @param processTotalCpuPercent the processTotalCpuPercent to set
	 */
	public void setProcessTotalCpu(long processTotalCpuPercent) {
		this.processTotalCpu = processTotalCpuPercent;
	}
	/**
	 * @return the processMemoryUsed
	 */
	public long getProcessMemoryUsed() {
		return processMemoryUsed;
	}
	/**
	 * @param processMemoryUsed the processMemoryUsed to set
	 */
	public void setProcessMemoryUsed(long processMemoryUsed) {
		this.processMemoryUsed = processMemoryUsed;
	}
	
	
	/**
	 * @return the processMemoryFree
	 */
	public long getProcessMemoryFree() {
		return processMemoryFree;
	}

	/**
	 * @param processMemoryFree the processMemoryFree to set
	 */
	public void setProcessMemoryFree(long processMemoryFree) {
		this.processMemoryFree = processMemoryFree;
	}

	/**
	 * @return the gfsUsed
	 */
	public long getGfsUsed() {
		return gfsUsed;
	}

	/**
	 * @param gfsUsed the gfsUsed to set
	 */
	public void setGfsUsed(long gfsUsed) {
		this.gfsUsed = gfsUsed;
	}

	/**
	 * @return the gfsFree
	 */
	public long getGfsFree() {
		return gfsFree;
	}

	/**
	 * @param gfsFree the gfsFree to set
	 */
	public void setGfsFree(long gfsFree) {
		this.gfsFree = gfsFree;
	}

	/**
	 * @return the mapsStats
	 */
	public HashMap<String, LightMapStats> getMapsStats() {
		return mapsStats;
	}
	/**
	 * @param mapsStats the mapsStats to set
	 */
	public void setMapsStats(HashMap<String, LightMapStats> mapsStats) {
		this.mapsStats = mapsStats;
	}
	
	/**
	 * @return the internalMapsStats
	 */
	public HashMap<String, LightMapStats> getInternalMapsStats() {
		return internalMapsStats;
	}

	/**
	 * @param internalMapsStats the internalMapsStats to set
	 */
	public void setInternalMapsStats(HashMap<String, LightMapStats> internalMapsStats) {
		this.internalMapsStats = internalMapsStats;
	}

	/* (non-Javadoc)
	 * @see java.lang.Object#toString()
	 */
	@Override
	public String toString() {
		return "LightMemberSample [memberKey=" + memberKey + ", memberLabel=" + memberLabel + ", memberHostname=" + memberHostname + ", pid=" + pid + ", key=" + key + ", time=" + time + ", numberOfJCLCheck=" + numberOfJCLCheck + ", numberOfJOBSubmitted="
				+ numberOfJOBSubmitted + ", totalNumberOfJCLCheck=" + totalNumberOfJCLCheck + ", totalNumberOfJOBSubmitted=" + totalNumberOfJOBSubmitted + ", cpuPercent=" + cpuPercent + ", memoryAvailable=" + memoryAvailable + ", memoryFree="
				+ memoryFree + ", processCpuPercent=" + processCpuPercent + ", processTotalCpu=" + processTotalCpu + ", processMemoryUsed=" + processMemoryUsed + ", processMemoryFree=" + processMemoryFree + ", gfsUsed=" + gfsUsed + ", gfsFree=" + gfsFree
				+ ", mapsStats=" + mapsStats + "]";
	}

}