/**
    JEM, the BEE - Job Entry Manager, the Batch Execution Environment
    Copyright (C) 2012, 2013   Andrea "Stock" Stocchero
    This program is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program.  If not, see <http://www.gnu.org/licenses/>.
*/
package org.pepstock.jem.node.stats;

import java.io.Serializable;

/**
 * @author Andrea "Stock" Stocchero
 * @version 1.0	
 *
 */
public class LightMapStats implements Serializable{
	
	private static final long serialVersionUID = 1L;

	private String name = null;
	
	private long ownedEntryCount = 0;
	
	private long ownedEntryMemoryCost = 0;

	private long lockedEntryCount = 0;
	
	private long lockWaitCount = 0;

	private long hits = 0;
	
	private long numberOfPuts = 0;

	private long numberOfGets = 0;

	private long totalPutLatency = 0;

	private long totalGetLatency = 0;

	private long totalRemoveLatency = 0;

	private long numberOfRemoves = 0;

	/**
	 * 
	 */
	public LightMapStats() {
	}

	/**
	 * @return the name
	 */
	public String getName() {
		return name;
	}

	/**
	 * @param name the name to set
	 */
	public void setName(String name) {
		this.name = name;
	}

	/**
	 * @return the ownedEntryCount
	 */
	public long getOwnedEntryCount() {
		return ownedEntryCount;
	}

	/**
	 * @param ownedEntryCount the ownedEntryCount to set
	 */
	public void setOwnedEntryCount(long ownedEntryCount) {
		this.ownedEntryCount = ownedEntryCount;
	}

	/**
	 * @return the ownedEntryMemoryCost
	 */
	public long getOwnedEntryMemoryCost() {
		return ownedEntryMemoryCost;
	}

	/**
	 * @param ownedEntryMemoryCost the ownedEntryMemoryCost to set
	 */
	public void setOwnedEntryMemoryCost(long ownedEntryMemoryCost) {
		this.ownedEntryMemoryCost = ownedEntryMemoryCost;
	}

	/**
	 * @return the lockedEntryCount
	 */
	public long getLockedEntryCount() {
		return lockedEntryCount;
	}

	/**
	 * @param lockedEntryCount the lockedEntryCount to set
	 */
	public void setLockedEntryCount(long lockedEntryCount) {
		this.lockedEntryCount = lockedEntryCount;
	}



	/**
	 * @return the lockWaitCount
	 */
	public long getLockWaitCount() {
		return lockWaitCount;
	}

	/**
	 * @param lockWaitCount the lockWaitCount to set
	 */
	public void setLockWaitCount(long lockWaitCount) {
		this.lockWaitCount = lockWaitCount;
	}

	/**
	 * @return the hits
	 */
	public long getHits() {
		return hits;
	}

	/**
	 * @param hits the hits to set
	 */
	public void setHits(long hits) {
		this.hits = hits;
	}

	/**
	 * @return the numberOfPuts
	 */
	public long getNumberOfPuts() {
		return numberOfPuts;
	}

	/**
	 * @param numberOfPuts the numberOfPuts to set
	 */
	public void setNumberOfPuts(long numberOfPuts) {
		this.numberOfPuts = numberOfPuts;
	}

	/**
	 * @return the numberOfGets
	 */
	public long getNumberOfGets() {
		return numberOfGets;
	}

	/**
	 * @param numberOfGets the numberOfGets to set
	 */
	public void setNumberOfGets(long numberOfGets) {
		this.numberOfGets = numberOfGets;
	}

	/**
	 * @return the totalPutLatency
	 */
	public long getTotalPutLatency() {
		return totalPutLatency;
	}

	/**
	 * @param totalPutLatency the totalPutLatency to set
	 */
	public void setTotalPutLatency(long totalPutLatency) {
		this.totalPutLatency = totalPutLatency;
	}

	/**
	 * @return the totalGetLatency
	 */
	public long getTotalGetLatency() {
		return totalGetLatency;
	}

	/**
	 * @param totalGetLatency the totalGetLatency to set
	 */
	public void setTotalGetLatency(long totalGetLatency) {
		this.totalGetLatency = totalGetLatency;
	}

	/**
	 * @return the totalRemoveLatency
	 */
	public long getTotalRemoveLatency() {
		return totalRemoveLatency;
	}

	/**
	 * @param totalRemoveLatency the totalRemoveLatency to set
	 */
	public void setTotalRemoveLatency(long totalRemoveLatency) {
		this.totalRemoveLatency = totalRemoveLatency;
	}

	/**
	 * @return the numberOfRemoves
	 */
	public long getNumberOfRemoves() {
		return numberOfRemoves;
	}

	/**
	 * @param numberOfRemoves the numberOfRemoves to set
	 */
	public void setNumberOfRemoves(long numberOfRemoves) {
		this.numberOfRemoves = numberOfRemoves;
	}

	/* (non-Javadoc)
	 * @see java.lang.Object#toString()
	 */
	@Override
	public String toString() {
		return "LightMapStats [name=" + name + ", ownedEntryCount=" + ownedEntryCount + ", ownedEntryMemoryCost=" + ownedEntryMemoryCost + ", hits=" + hits + ", numberOfPuts=" + numberOfPuts + ", numberOfGets=" + numberOfGets + ", totalPutLatency="
				+ totalPutLatency + ", totalGetLatency=" + totalGetLatency + ", totalRemoveLatency=" + totalRemoveLatency + ", numberOfRemoves=" + numberOfRemoves + "]";
	}

	
}