/**
    JEM, the BEE - Job Entry Manager, the Batch Execution Environment
    Copyright (C) 2012, 2013   Andrea "Stock" Stocchero
    This program is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program.  If not, see <http://www.gnu.org/licenses/>.
*/
package org.pepstock.jem.node.rmi;

import java.rmi.RemoteException;

import javax.naming.Reference;

import org.pepstock.jem.node.resources.Resource;
import org.pepstock.jem.util.rmi.RmiObject;

/**
 * is RMI interface for having datasources or other common resources.<br>
 * 
 * @author Andrea "Stock" Stocchero
 * 
 */
public interface CommonResourcer extends RmiObject {

	/**
	 * RMI object ID for binding.
	 */
	public static final String NAME = "COMMON_RESOURCE";

	/**
	 * Asks by name for the common resource.
	 * 
	 * @param resourceName resource name
	 * @return resource as common resource
	 * @throws RemoteException occurs if errors
	 */
	public Resource lookup(String resourceName) throws RemoteException;

	/**
	 * Asks by type for JNDI reference of the custom common resource.
	 * 
	 * @param resourceType resource type
	 * @return JDNI reference of custom common resource
	 * @throws RemoteException occurs if errors
	 */
	public Reference lookupCustomResource(String resourceType) throws RemoteException;

}