package org.pepstock.jem.node.resources.custom.fields;

import java.io.Serializable;

import org.pepstock.jem.node.resources.custom.ResourcePartDescriptor;

/**
 * This class represent a generic custom resource field. 
 * @author Marco "Fuzzo" Cuccato
 */
public abstract class AbstractFieldDescriptor implements Serializable, ResourcePartDescriptor {

	private static final long serialVersionUID = 9211550672246128720L;

	private String key = null;
	private String label = null;
	private String description = null;
	private boolean mandatory = false;
	private boolean override = true;
	private boolean visible = true;

	/**
	 * Builds the field
	 * @param key the field key, identifier of the field
	 * @param label the field label, what the user see next to this field 
	 */
	public AbstractFieldDescriptor(String key, String label) {
		setKey(key);
		setLabel(label);
	}
	
	/**
	 * @return the field key
	 */
	public String getKey() {
		return key;
	}

	/**
	 * Sets the field key
	 * @param key the key that identify the field
	 */
	public void setKey(String key) {
		this.key = key;
	}

	/**
	 * @return the label of this field
	 */
	public String getLabel() {
		return label;
	}

	/**
	 * Sets the field label
	 * @param label the label of the field
	 */
	public void setLabel(String label) {
		this.label = label;
	}

	/**
	 * @return a "long" description of this field
	 */
	public String getDescription() {
		return description;
	}

	/**
	 * Sets the field description
	 * @param description the field description
	 */
	public void setDescription(String description) {
		this.description = description;
	}

	/**
	 * @return <code>true</code> if this field needs to be filled/selected, <code>false</code> is this field is optional and can not be filled/selected
	 */
	public boolean isMandatory() {
		return mandatory;
	}

	/**
	 * Sets if this field is mandatory or not
	 * @param mandatory <code>true</code> if you want this field to be mandatory, <code>false</code> otherwhise
	 */
	public void setMandatory(boolean mandatory) {
		this.mandatory = mandatory;
	}

	/**
	 * @return the override
	 */
	public boolean isOverride() {
		return override;
	}

	/**
	 * @param override the override to set
	 */
	public void setOverride(boolean override) {
		this.override = override;
	}

	/**
	 * @return the visible
	 */
	public boolean isVisible() {
		return visible;
	}

	/**
	 * @param visible the visible to set
	 */
	public void setVisible(boolean visible) {
		this.visible = visible;
	}
	
}
