/**
    JEM, the BEE - Job Entry Manager, the Batch Execution Environment
    Copyright (C) 2012, 2013   Andrea "Stock" Stocchero
    This program is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program.  If not, see <http://www.gnu.org/licenses/>.
*/
package org.pepstock.jem.node.persistence;

/**
 * @author Andrea "Stock" Stocchero
 * @version 1.0	
 *
 */
public interface SQLContainerFactory {
	
	/**
	 * @return SQLContainer
	 */
	public SQLContainer getSQLContainerForCheckingQueue();
	
	/**
	 * @return SQLContainer
	 */
	public SQLContainer getSQLContainerForInputQueue();

	/**
	 * @return SQLContainer
	 */
	public SQLContainer getSQLContainerForRunningQueue();


	/**
	 * @return SQLContainer
	 */
	public SQLContainer getSQLContainerForOutputQueue();
	
	/**
	 * @return SQLContainer
	 */ 
	public SQLContainer getSQLContainerForRoutingQueue();
	
	/**
	 * @return SQLContainer
	 */
	public SQLContainer getSQLContainerForRolesMap();
	
	/**
	 * @return SQLContainer
	 */
	public SQLContainer getSQLContainerForCommonResourcesMap();
	
	/**
	 * @return SQLContainer
	 */
	public SQLContainer getSQLContainerForRoutingConfigMap();
	
	/**
	 * @return SQLContainer
	 */
	public SQLContainer getSQLContainerForUserPreferencesMap();

	/**
	 * @return the query to execute to maintain alive the connection with DB
	 */
	public String getKeepAliveConnectionSQL();

}