/**
    JEM, the BEE - Job Entry Manager, the Batch Execution Environment
    Copyright (C) 2012, 2013   Andrea "Stock" Stocchero
    This program is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program.  If not, see <http://www.gnu.org/licenses/>.
*/
package org.pepstock.jem.node.persistence;

import java.util.concurrent.TimeUnit;

import org.pepstock.jem.Job;
import org.pepstock.jem.log.LogAppl;
import org.pepstock.jem.node.Main;
import org.pepstock.jem.node.NodeMessage;
import org.pepstock.jem.node.Queues;

import com.hazelcast.core.IMap;

/**
 * @author Andrea "Stock" Stocchero
 * @version 1.0	
 *
 */
public class RedoManager{

	private String queueName = null;
	
	/**
	 * @param queueName 
	 * 
	 */
	public RedoManager(String queueName) {
		this.queueName = queueName;
	}
	
	/**
	 * @return the queueName
	 */
	public String getQueueName() {
		return queueName;
	}

	/**
	 * 
	 * @param queueName
	 * @param job
	 */
	public void store(Job job) {
		IMap<Long, RedoStatement> redoMap = Main.HAZELCAST.getMap(Queues.REDO_STATEMENT_MAP);
		try{
			redoMap.lockMap(10, TimeUnit.SECONDS);
			Long id = Long.valueOf(redoMap.size() + 1);
			
			RedoStatement statement = new RedoStatement();
			statement.setId(id);
			statement.setQueueName(queueName);
			statement.setJob(job);
			statement.setAction(RedoStatement.STORE);
			
			redoMap.put(id, statement);

			LogAppl.getInstance().emit(NodeMessage.JEMC179I, statement.toString());
		} catch (Exception ex) {
			LogAppl.getInstance().emit(NodeMessage.JEMC180E, ex);
		} finally {
			redoMap.unlockMap();
		}		
	}
	
	/**
	 * 
	 * @param queueName
	 * @param jobId
	 */
	public void delete(String jobId) {
		IMap<Long, RedoStatement> redoMap = Main.HAZELCAST.getMap(Queues.REDO_STATEMENT_MAP);
		try{
			redoMap.lockMap(10, TimeUnit.SECONDS);
			Long id = Long.valueOf(redoMap.size() + 1);
			
			RedoStatement statement = new RedoStatement();
			statement.setId(id);
			statement.setQueueName(queueName);
			statement.setJobId(jobId);
			statement.setAction(RedoStatement.DELETE);
			
			redoMap.put(id, statement);
			LogAppl.getInstance().emit(NodeMessage.JEMC179I, statement.toString());
		} catch (Exception ex) {
			LogAppl.getInstance().emit(NodeMessage.JEMC180E, ex);
		} finally {
			redoMap.unlockMap();
		}		
	}
}