/**
    JEM, the BEE - Job Entry Manager, the Batch Execution Environment
    Copyright (C) 2012, 2013   Andrea "Stock" Stocchero
    This program is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program.  If not, see <http://www.gnu.org/licenses/>.
*/
package org.pepstock.jem.node.executors.configuration;

import org.pepstock.jem.node.configuration.ConfigKeys;
import org.pepstock.jem.node.configuration.Configuration;
import org.pepstock.jem.node.configuration.CustomResourceDefinition;
import org.pepstock.jem.node.configuration.Database;
import org.pepstock.jem.node.configuration.Factory;
import org.pepstock.jem.node.configuration.Listener;
import org.pepstock.jem.node.configuration.Node;
import org.pepstock.jem.node.configuration.StatsManager;
import org.pepstock.jem.node.executors.DefaultExecutor;

import com.thoughtworks.xstream.XStream;

/**
 * Tests if JEM environment configuration file, updated by user interface, is consistent and valid (creating a temporary configuration).
 * 
 * @author Andrea "Stock" Stocchero
 * @version 1.4
 * 
 */
public class CheckJemEnvConfiguration extends DefaultExecutor<Boolean>{

	private static final long serialVersionUID = 1L;
	
	private String content = null;
	
	/**
	 * Constructs the object with JEM environment configuration file content to test
	 * @param content configuration file content to check
	 */
	public CheckJemEnvConfiguration(String content) {
		this.content = content;
	}

	/**
	 * Checks if content could be a JEM environment configuration file
	 * @return always TRUE
	 * @throws Exception occurs if errors
	 */
	@Override
	public Boolean execute() throws Exception {
		// load Xstream and set alias to have a configuration tags user friendly
		XStream xstream = new XStream();

		xstream.alias(ConfigKeys.CONFIGURATION_TAG, Configuration.class);
		
		xstream.aliasField(ConfigKeys.STATISTICS_MANAGER_ALIAS, Configuration.class, ConfigKeys.STATISTICS_MANAGER_FIELD);
		xstream.alias(ConfigKeys.NODE_ALIAS, Node.class);
		xstream.alias(ConfigKeys.DATABASE_ELEMENT, Database.class);

		xstream.alias(ConfigKeys.FACTORY_ALIAS, Factory.class);
		xstream.aliasAttribute(Factory.class, ConfigKeys.CLASS_NAME_FIELD, ConfigKeys.CLASS_NAME_ATTRIBUTE_ALIAS);

		xstream.alias(ConfigKeys.LISTENER_ALIAS, Listener.class);
		xstream.aliasAttribute(Listener.class, ConfigKeys.CLASS_NAME_FIELD, ConfigKeys.CLASS_NAME_ATTRIBUTE_ALIAS);
		
		xstream.aliasAttribute(StatsManager.class, ConfigKeys.PATH_FIELD, ConfigKeys.PATH_ATTRIBUTE_ALIAS);
		xstream.aliasAttribute(StatsManager.class, ConfigKeys.ENABLE_FIELD, ConfigKeys.ENABLE_ATTRIBUTE_ALIAS);

		xstream.alias(ConfigKeys.RESOURCE_DEFINITION_ALIAS, CustomResourceDefinition.class);
		xstream.aliasAttribute(CustomResourceDefinition.class, ConfigKeys.CLASS_NAME_FIELD, ConfigKeys.CLASS_NAME_ATTRIBUTE_ALIAS);
		xstream.aliasField(ConfigKeys.RESOURCE_DEFINITIONS_ALIAS, Configuration.class, ConfigKeys.RESOURCE_DEFINITIONS_FIELD);		

		// load configuration file by XStream. if object is not a instance of
		// Configuration, exception occurs
		try {
			xstream.fromXML(content);
		} catch (Exception e) {
			e.printStackTrace();
			// NOTE that we are using the message of cause exception
			// where is written which row has got the error
			throw new Exception(e.getCause().getMessage());
		}
		return Boolean.TRUE;
	}
}