/**
    JEM, the BEE - Job Entry Manager, the Batch Execution Environment
    Copyright (C) 2012, 2013   Andrea "Stock" Stocchero
    This program is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */
package org.pepstock.jem.node.executors.certificates;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

import org.apache.commons.lang3.StringUtils;
import org.pepstock.jem.node.executors.DefaultExecutor;
import org.pepstock.jem.node.security.CertificateEntry;
import org.pepstock.jem.node.security.keystore.CertificatesUtil;

/**
 * Returns a list of already defined certificates inside of JEM.
 * 
 * @author Andrea "Stock" Stocchero
 * @version 1.4
 */
public class GetCertificates extends DefaultExecutor<Collection<CertificateEntry>> {

	private static final long serialVersionUID = 1L;

	private String filter = null;

	/**
	 * Constructs the object using the filter to apply to get the list
	 * @param filter filter to get a subset (or whole) list
	 * 
	 */
	public GetCertificates(String filter) {
		this.filter = filter;
	}

	/* (non-Javadoc)
	 * @see org.pepstock.jem.node.executors.DefaultExecutor#execute()
	 */
	@Override
	public Collection<CertificateEntry> execute() throws Exception {
		// creates reuslt list
		ArrayList<CertificateEntry> result = new ArrayList<CertificateEntry>();
		// gets all piblished certificates 
		List<CertificateEntry> list = CertificatesUtil.getCertificates();
		// scans to filter
		for (CertificateEntry entry : list) {
			// scans only certificate with an issuer
			if (entry.getIssuer() != null) {
				// filter by alias (then userid)
				if (filter.equals("") || StringUtils.containsIgnoreCase(entry.getAlias(), filter)) {
					result.add(entry);
				}
			}
		}
		return result;
	}

}
