/**
    JEM, the BEE - Job Entry Manager, the Batch Execution Environment
    Copyright (C) 2012, 2013   Andrea "Stock" Stocchero
    This program is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */
package org.pepstock.jem.node.executors.certificates;

import org.pepstock.jem.node.executors.DefaultExecutor;
import org.pepstock.jem.node.security.keystore.CertificatesUtil;

/**
 * Adds a new user certificate into JEM. The certificate is necessary when JEM is configured with 
 * socket interceptor and all submitter must use a certificate to authenticate themselves to JEM.
 *  
 * @author Andrea "Stock" Stocchero
 * @version 1.4
 */
public class AddCertificate extends DefaultExecutor<Boolean> {

	private static final long serialVersionUID = 1L;

	private String userid = null;
	
	private byte[] certificate = null;
	

	/**
	 * Constructs using certificate (in byte format) and userid (is consider the alias in keystore)
	 * 
	 * @param userid user id  
	 * @param certificate certificate in byte format 
	 * 
	 */
	public AddCertificate(byte[] certificate, String userid) {
		this.userid = userid;
		this.certificate = certificate;
	}

	/* (non-Javadoc)
	 * @see org.pepstock.jem.node.executors.DefaultExecutor#execute()
	 */
	@Override
	public Boolean execute() throws Exception {
		CertificatesUtil.addCertificate(certificate, userid);
		return Boolean.TRUE;
	}

}
