/**
    JEM, the BEE - Job Entry Manager, the Batch Execution Environment
    Copyright (C) 2012, 2013   Andrea "Stock" Stocchero
    This program is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program.  If not, see <http://www.gnu.org/licenses/>.
*/
package org.pepstock.jem.node.configuration;

import java.io.Serializable;

import org.pepstock.jem.Jcl;

/**
 * Contains the environment, domain and affinity information for the node.
 * 
 * @author Andrea "Stock" Stocchero
 * 
 */
public class ExecutionEnvironment implements Serializable {

	private static final long serialVersionUID = 1L;
	
	private String environment = null;

	private String domain = Jcl.DEFAULT_DOMAIN;

	private String affinity = Jcl.DEFAULT_AFFINITY;
	
	private AffinityFactory affinityFactory = null;

	/**
	 * Empty constructor
	 */
	public ExecutionEnvironment() {
	}

	/**
	 * Returns the name of cluster (see Hazelcast "group" definition) that the
	 * node uses to submit jobs.
	 * 
	 * @return the name of cluster
	 */
	public String getEnvironment() {
		return environment;
	}

	/**
	 * Sets the name of cluster that the node uses to submit jobs.
	 * 
	 * @param environment the name of cluster
	 */
	public void setEnvironment(String environment) {
		this.environment = environment;
	}

	/**
	 * Returns the name of domain. Domain is a subset of nodes that the node
	 * uses to submit jobs. Default is Job.DEFAULT_DOMAIN
	 * 
	 * @see org.pepstock.jem.Job#DEFAULT_DOMAIN
	 * @return the name of domain
	 */
	public String getDomain() {
		return domain;
	}

	/**
	 * Sets the name of domain that the node uses to submit jobs.
	 * 
	 * @param domain the name of domain
	 */
	public void setDomain(String domain) {
		this.domain = domain;
	}

	/**
	 * Returns the name of affinity that the node uses to submit jobs.
	 * 
	 * @return the name of affinity
	 */
	public String getAffinity() {
		return affinity;
	}

	/**
	 * Sets the name of affinity that the node uses to submit jobs.
	 * 
	 * @param affinity the name of affinity
	 */
	public void setAffinity(String affinity) {
		this.affinity = affinity;
	}

	/**
	 * Returns the factory to load affinities and set memory limit
	 * 
	 * @return the affinityFactory
	 * @see AffinityFactory
	 */
	public AffinityFactory getAffinityFactory() {
		return affinityFactory;
	}

	/**
	 * Sets the factory to load affinities and set memory limit
	 * 
	 * @param affinityFactory the affinityFactory to set
	 * @see AffinityFactory
	 */
	public void setAffinityFactory(AffinityFactory affinityFactory) {
		this.affinityFactory = affinityFactory;
	}

	
}