/**
    JEM, the BEE - Job Entry Manager, the Batch Execution Environment
    Copyright (C) 2012, 2013   Andrea "Stock" Stocchero
    This program is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program.  If not, see <http://www.gnu.org/licenses/>.
*/
package org.pepstock.jem.node.configuration;

import java.util.ArrayList;

/**
 * Main configuration bean object. Contains all "children" to configure properly
 * JEM node.
 * 
 * @author Andrea "Stock" Stocchero
 * 
 */
public class Configuration {

	private ExecutionEnvironment executionEnviroment = null;

	private ArrayList<Factory> factories = null;

	private Paths paths = null;

	private ArrayList<Listener> listeners = null;
	
	private Node node = null;
	
	private Database database = null;
	
	private StatsManager statsManager = null;

	private ArrayList<CustomResourceDefinition> resourceDefinitions = null;
												
	
	/**
	 * Empty constructor.
	 */
	public Configuration() {
	}

	/**
	 * Returns the execution environment configured for node.
	 * 
	 * @return the execution environment configured for node
	 */
	public ExecutionEnvironment getExecutionEnviroment() {
		return executionEnviroment;
	}

	/**
	 * Sets the execution environment configured for node.
	 * 
	 * @param executionEnviroment
	 */
	public void setExecutionEnviroment(ExecutionEnvironment executionEnviroment) {
		this.executionEnviroment = executionEnviroment;
	}

	/**
	 * Returns the list of defined factories for job task and JCL.
	 * 
	 * @return the list of defined factories for job task and JCL
	 */
	public ArrayList<Factory> getFactories() {
		return factories;
	}

	/**
	 * Sets the list of defined factories for job task and JCL.
	 * 
	 * @param factories Returns the list of defined factories for job task and
	 *            JCL
	 */
	public void setFactories(ArrayList<Factory> factories) {
		this.factories = factories;
	}

	/**
	 * Returns the paths container, used to gather all path definition
	 * necessary.
	 * 
	 * @return the paths container
	 */
	public Paths getPaths() {
		return paths;
	}

	/**
	 * Sets the paths container, used to gather all path definition necessary.
	 * 
	 * @param paths the paths container
	 */
	public void setPaths(Paths paths) {
		this.paths = paths;
	}

	/**
	 * Returns the list of defined listeners for job life-cycle.
	 * 
	 * @return the list of defined listeners for job life-cycle.
	 */
	public ArrayList<Listener> getListeners() {
		return listeners;
	}

	/**
	 * Sets the list of defined listeners for job life-cycle.
	 * 
	 * @param listeners the list of defined listeners for job life-cycle.
	 */
	public void setListeners(ArrayList<Listener> listeners) {
		this.listeners = listeners;
	}
	
	/**
	 * Returns the list of defined resource definitions for custom resources configuration.
	 * 
	 * @return the list of defined resource definitions for custom resources configuration.
	 */
	public ArrayList<CustomResourceDefinition> getResourceDefinitions() {
		return resourceDefinitions;
	}

	/**
	 * Sets the list of defined resource definitions for custom resources configuration.
	 * 
	 * @param resourceDefinitions the list of defined resource definitions for custom resources configuration.
	 */
	public void setResourceDefinitions(ArrayList<CustomResourceDefinition> resourceDefinitions) {
		this.resourceDefinitions = resourceDefinitions;
	}
	

	/**
	 * @return the node
	 */
	public Node getNode() {
		return node;
	}

	/**
	 * @param node the node to set
	 */
	public void setNode(Node node) {
		this.node = node;
	}

	/**
	 * @return the database
	 */
	public Database getDatabase() {
		return database;
	}

	/**
	 * @param database the database to set
	 */
	public void setDatabase(Database database) {
		this.database = database;
	}

	/**
	 * @return the statisticsManager
	 */
	public StatsManager getStatsManager() {
		return statsManager;
	}

	/**
	 * @param statisticsManager the statisticsManager to set
	 */
	public void setStatsManager(StatsManager statisticsManager) {
		this.statsManager = statisticsManager;
	}
	
	
	
}