/**
    JEM, the BEE - Job Entry Manager, the Batch Execution Environment
    Copyright (C) 2012, 2013   Andrea "Stock" Stocchero
    This program is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program.  If not, see <http://www.gnu.org/licenses/>.
*/
package org.pepstock.jem.node;

import java.util.Map.Entry;
import java.util.Set;

import com.hazelcast.config.MapConfig;
import com.hazelcast.config.MapStoreConfig;
import com.hazelcast.core.MapStore;

/**
 * @author Andrea "Stock" Stocchero
 * @version 1.4
 */
public class DataLossHandler implements Runnable {
	
	private long lastMigrationCompleted = -1L;
	
	private boolean ready = true;

	/**
	 * 
	 */
	public DataLossHandler() {
	}

	/**
	 * @return the ready
	 */
	public boolean isReady() {
		return ready;
	}

	/**
	 * @param ready the ready to set
	 */
	public void setReady(boolean ready) {
		this.ready = ready;
	}

	/**
	 * @return the lastMigrationCompleted
	 */
	public long getLastMigrationCompleted() {
		return lastMigrationCompleted;
	}

	/**
	 * @param lastMigrationCompleted the lastMigrationCompleted to set
	 */
	public void setLastMigrationCompleted(long lastMigrationCompleted) {
		this.lastMigrationCompleted = lastMigrationCompleted;
	}

	/* (non-Javadoc)
	 * @see java.lang.Runnable#run()
	 */
	@Override
	public void run() {
		setReady(false);
		try {
			while(true){
				Thread.sleep(1000L);
				if (getLastMigrationCompleted() >= 0){
					long diff = System.currentTimeMillis() - getLastMigrationCompleted();
					System.out.println(diff);
					if ((diff) > 5000L){
						load();
						setReady(true);
						return;
					}
				}
			}
		} catch (InterruptedException e) {
		}
	}
	
	private void load(){
		long start = System.currentTimeMillis();
		for (Entry<String, MapConfig> configs : Main.HAZELCAST.getConfig().getMapConfigs().entrySet()){
			String key = configs.getKey(); 
			MapStoreConfig mStoreConfig = configs.getValue().getMapStoreConfig();

			if (mStoreConfig != null){
				if (mStoreConfig.isEnabled()){
					try {
						//								@SuppressWarnings("rawtypes")
						MapStore<String, Object> clazz = (MapStore<String, Object>)Class.forName(mStoreConfig.getClassName()).newInstance();
						//								@SuppressWarnings("unchecked")
						Set<String> keys = clazz.loadAllKeys();
						for (String storeKey : keys){
							Main.HAZELCAST.getMap(key).containsKey(storeKey);	
						}

					} catch (InstantiationException e) {
						e.printStackTrace();
					} catch (IllegalAccessException e) {
						e.printStackTrace();
					} catch (ClassNotFoundException e) {
						e.printStackTrace();
					}

				}
			}
		}
		long end = System.currentTimeMillis() - start;
		System.err.println("Recovery in "+end);

	}

}
