/**
    JEM, the BEE - Job Entry Manager, the Batch Execution Environment
    Copyright (C) 2012, 2013   Andrea "Stock" Stocchero
    This program is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program.  If not, see <http://www.gnu.org/licenses/>.
*/
package org.pepstock.jem.console.commands.resources;

import java.util.Properties;

import org.apache.commons.cli.Option;
import org.apache.commons.cli.OptionBuilder;
import org.pepstock.jem.commands.util.ArgumentsParser;
import org.pepstock.jem.console.HttpManager;
import org.pepstock.jem.log.LogAppl;
import org.pepstock.jem.node.NodeMessage;


/**
 * Remove a resource into JEM.<br>
 * Is a command (to execute by command line) where 1 argument is mandatory: <br>
 * <code>-name [name]</code> indicates the name of resource.<br>
 * <br>
 * <b>RemoveResource -name ... </b><br>
 * <br>
 * Is possible to have help from command line by <code>-help</code> argument.<br>
 * 
 * @author Andrea "Stock" Stocchero
 *
 */
public class Remove extends ResourceCommand{
	
	private static final String ACTION = org.pepstock.jem.console.commands.resources.Remove.class.getName();

	private static final String KEY = "removeResource";
	
	private static final String DESCRIPTION = "Removes a resource defintion by resource name";

	/**
	 * Key for the name of resource 
	 */
	private static String NAME = "name";
	
	/**
	 * Empty constructor
	 */
	public Remove(){
		super(ACTION);
	}

	/* (non-Javadoc)
	 * @see org.pepstock.jem.console.Command#execute(java.lang.String)
	 */
	@SuppressWarnings("static-access")
	@Override
	public void execute(String userid, String groupid) throws Exception {
		// -name mandatory arg
		Option name = OptionBuilder.withArgName(NAME).hasArg().withDescription("use given resource name").create(NAME);
		name.setRequired(true);
		ArgumentsParser parser = new ArgumentsParser(this.getClass().getName(), name);
		Properties props = parser.parseArg(getArguments());

		// gets resource name
		String resource_name = props.getProperty(NAME);
		
		Object object = HttpManager.getInstance().execute(COMMON_RESOURCES_QUERY_STRING, getParameters(), resource_name);
		Boolean isRemoved = (Boolean)object;
		LogAppl.getInstance().emit((isRemoved) ? NodeMessage.JEMC061I : NodeMessage.JEMC062W, resource_name);
	}

	/* (non-Javadoc)
	 * @see org.pepstock.jem.console.Command#getCommandKey()
	 */
	@Override
	public String getKey() {
		return KEY;
	}

	/* (non-Javadoc)
	 * @see org.pepstock.jem.console.Command#getDescription()
	 */
	@Override
	public String getDescription() {
		return DESCRIPTION;
	}

}