/**
    JEM, the BEE - Job Entry Manager, the Batch Execution Environment
    Copyright (C) 2012, 2013   Andrea "Stock" Stocchero
    This program is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program.  If not, see <http://www.gnu.org/licenses/>.
*/
package org.pepstock.jem.console.commands;

import java.io.File;
import java.io.FileNotFoundException;
import java.util.Scanner;

import org.apache.commons.io.FilenameUtils;
import org.pepstock.jem.console.Command;
import org.pepstock.jem.console.JemConsole;

/**
 * @author Andrea "Stock" Stocchero
 * @version 1.0	
 *
 */
public class ViewFile extends Command {
	
	private static final String KEY = "view";
	
	private static final String DESCRIPTION = "Browses the content of a file";
	
	/* (non-Javadoc)
	 * @see org.pepstock.jem.console.Command#execute(java.lang.String)
	 */
	@Override
	public void execute(String userid, String groupid) throws Exception {
		String[] args = getArguments();
		if (args != null){
			if (args.length > 1){
				File newPath = new File(args[1]);
				if (!newPath.exists()){
					newPath = new File(FilenameUtils.concat(JemConsole.CURRENT_DIRECTORY.getAbsolutePath(), args[1]));
				}
				if (newPath.exists() && !newPath.isDirectory()){
					printFile(newPath);
				} else {
					print("File '"+args[1]+"' not found");
				}
			}
		}
	}

	/* (non-Javadoc)
	 * @see org.pepstock.jem.console.Command#getKey()
	 */
	@Override
	public String getKey() {
		return KEY;
	}

	/* (non-Javadoc)
	 * @see org.pepstock.jem.console.Command#getDescription()
	 */
	@Override
	public String getDescription() {
		return DESCRIPTION;
	}

	
	/**
	 * Reads JCL content from URL and returns it in string format
	 * 
	 * @param file JCL file
	 */
	private void printFile(File file){
		// read the JCL file
		Scanner sc = null;
		try {
			sc = new Scanner(file);
			sc.useDelimiter("\n");
			while(sc.hasNext()){
				print(sc.next().toString());
			}
			
		} catch (FileNotFoundException e) {
			e.printStackTrace(JemConsole.CONSOLE.getWriter());
		} finally {
			if (sc != null)
				sc.close();
		}
	}
}