/**
    JEM, the BEE - Job Entry Manager, the Batch Execution Environment
    Copyright (C) 2012, 2013   Andrea "Stock" Stocchero
    This program is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program.  If not, see <http://www.gnu.org/licenses/>.
*/
package org.pepstock.jem.console.commands;

import java.io.File;
import java.text.MessageFormat;
import java.util.Arrays;
import java.util.Date;

import org.apache.commons.io.FilenameUtils;
import org.apache.commons.lang3.StringUtils;
import org.pepstock.jem.console.Command;
import org.pepstock.jem.console.JemConsole;

/**
 * @author Andrea "Stock" Stocchero
 * @version 1.0	
 *
 */
public class ListDirectory extends Command {
	
	private static final String KEY = "ls";
	
	private static final String DESCRIPTION = "Listes the content of current local directory";
	
	private static final String FORMAT = "{0} {1} {2,date, dd-MMM-yyyy} {2,time, HH:mm:ss} {3,number,###,###,###,###,##0}";
	
	private static final String DIRECTORY = "<dir>";
	
	/* (non-Javadoc)
	 * @see org.pepstock.jem.console.Command#execute(java.lang.String)
	 */
	@Override
	public void execute(String userid, String groupid) throws Exception {
		print("Current directory: "+ FilenameUtils.normalize(JemConsole.CURRENT_DIRECTORY.getAbsolutePath()));
		File[] files = JemConsole.CURRENT_DIRECTORY.listFiles();
		Arrays.sort(files);
		for (int i=0; i<files.length; i++){
			String msg = MessageFormat.format(FORMAT, 
					StringUtils.rightPad(FilenameUtils.getName(files[i].getAbsolutePath()), 32), 
					(files[i].isDirectory()) ? DIRECTORY : StringUtils.repeat(" ", DIRECTORY.length()), 
					new Date(files[i].lastModified()), 
					files[i].length());
			
			
			JemConsole.CONSOLE.print(msg);
		}
	}

	/* (non-Javadoc)
	 * @see org.pepstock.jem.console.Command#getKey()
	 */
	@Override
	public String getKey() {
		return KEY;
	}

	/* (non-Javadoc)
	 * @see org.pepstock.jem.console.Command#getDescription()
	 */
	@Override
	public String getDescription() {
		return DESCRIPTION;
	}

}