/**
    JEM, the BEE - Job Entry Manager, the Batch Execution Environment
    Copyright (C) 2012, 2013   Andrea "Stock" Stocchero
    This program is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program.  If not, see <http://www.gnu.org/licenses/>.
*/
package org.pepstock.jem.console.commands;

import java.io.File;

import org.apache.commons.io.FilenameUtils;
import org.pepstock.jem.console.Command;
import org.pepstock.jem.console.JemConsole;

/**
 * @author Andrea "Stock" Stocchero
 * @version 1.0	
 *
 */
public class ChangeDirectory extends Command {
	
	private static final String KEY = "cd";
	
	private static final String DESCRIPTION = "Changes the current local directory";
	
	private static final String CURRENT_DIRECTORY_COMMAND = ".";
	
	private static final String PARENT_DIRECTORY_COMMAND = "..";
	
	/* (non-Javadoc)
	 * @see org.pepstock.jem.console.Command#execute(java.lang.String)
	 */
	@Override
	public void execute(String userid, String groupid) throws Exception {
		String[] args = getArguments();
		if (args != null){
			if (args.length > 1){
				if (args[1].equalsIgnoreCase(CURRENT_DIRECTORY_COMMAND)){
					// do nothing
				} else {
					File newPath = null;
					if (args[1].equalsIgnoreCase(PARENT_DIRECTORY_COMMAND)){
						newPath = JemConsole.CURRENT_DIRECTORY.getParentFile();
					} else {
						newPath = new File(args[1]);
						if (!newPath.isAbsolute()){
							newPath = new File(FilenameUtils.concat(JemConsole.CURRENT_DIRECTORY.getAbsolutePath(), args[1]));
						}
					}
					if (newPath.exists() && newPath.isDirectory()){
						JemConsole.CURRENT_DIRECTORY = newPath;
						print("Current directory: "+ FilenameUtils.normalize(JemConsole.CURRENT_DIRECTORY.getAbsolutePath()));
					} else {
						print("Directory '"+args[1]+"' not found");
					}
					return;
				} 
			}
		}
		print("Current directory: "+ FilenameUtils.normalize(JemConsole.CURRENT_DIRECTORY.getAbsolutePath()));
	}

	/* (non-Javadoc)
	 * @see org.pepstock.jem.console.Command#getKey()
	 */
	@Override
	public String getKey() {
		return KEY;
	}

	/* (non-Javadoc)
	 * @see org.pepstock.jem.console.Command#getDescription()
	 */
	@Override
	public String getDescription() {
		return DESCRIPTION;
	}

}