/**
    JEM, the BEE - Job Entry Manager, the Batch Execution Environment
    Copyright (C) 2012, 2013   Andrea "Stock" Stocchero
    This program is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program.  If not, see <http://www.gnu.org/licenses/>.
*/
package org.pepstock.jem.console;


/**
 * Abstract class to create a command for teh console.
 * 
 * @author Andrea "Stock" Stocchero
 * @version 1.0
 * 
 */
public abstract class Command {
	
	private String[] args = null;
	

	/**
	 * Empty constructor
	 */
	public Command(){
	}


	/**
	 * Returns the command line in words
	 * @return array of words which represents the command arguments
	 */
	public String[] getArguments() {
		return args;
	}

	/**
	 * Sets the command line in words
	 * @param args array of words which represents the command arguments
	 */
	public void setArguments(String[] args) {
		this.args = args;
	}

	/**
	 * Prints a buffer to the console output 
	 * @param buffer record to print
	 */
	public final void print(StringBuffer buffer){
		print(buffer.toString());
	}
	
	/**
	 * Prints a record to the console output
	 * @param record to print
	 */
	public final void print(String record){
		JemConsole.CONSOLE.print(record);
	}

	/**
	 * Execute the command
	 * @param userid 
	 * @param groupid 
	 * 
	 * @throws Exception if an error occurs
	 */
	public abstract void execute(String userid, String groupid) throws Exception;
	
	/**
	 * Returns the keyword of command
	 * @return keyword of command
	 */
	public abstract String getKey();
	
	/**
	 * Gets the command description
	 * @return command description
	 */
	public abstract String getDescription();

}