/**
    JEM, the BEE - Job Entry Manager, the Batch Execution Environment
    Copyright (C) 2012, 2013   Andrea "Stock" Stocchero
    This program is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program.  If not, see <http://www.gnu.org/licenses/>.
*/
package org.pepstock.jem.commands.util;

import java.net.InetAddress;

import org.pepstock.jem.node.security.socketinterceptor.SubmitInterceptor;

import com.hazelcast.client.ClientConfig;
import com.hazelcast.client.HazelcastClient;
import com.hazelcast.core.HazelcastInstance;

/**
 * @author Andrea "Stock" Stocchero
 * @version 1.0
 * 
 */
public class HazelcastUtil {

	/**
	 * @param env is the name of the JEM environment
	 * @param port is the port number
	 * @param envPassword is the password for the environment
	 * @param privateKeyPathFile
	 * @param privateKeyPasswd 
	 * @param userId 
	 * @return hazelcast instance
	 * @throws Exception
	 */
	public static final HazelcastInstance getLocalInstance(String env, String port, String envPassword, String privateKeyPathFile, String privateKeyPasswd, String userId) throws Exception {
		// creates a client configuration for Hazelcast
		ClientConfig clientConfig = new ClientConfig();
		clientConfig.getGroupConfig().setName(env).setPassword(envPassword);
		clientConfig.addAddress(InetAddress.getLocalHost().getHostAddress() + ":" + port);
		// check if the environment has the socket interceptor enable is so
		// use it also in the client to login correctly
		if (privateKeyPathFile != null) {
			SubmitInterceptor myClientSocketInterceptor = new SubmitInterceptor(privateKeyPathFile, privateKeyPasswd, userId);
			clientConfig.setSocketInterceptor(myClientSocketInterceptor);
		}

		// creates a new Client instance of Hazelcast
		return HazelcastClient.newHazelcastClient(clientConfig);
	}

	/**
	 * @param url is the url of the web node
	 * @param envPassword is the password for the environment
	 * @param privateKeyPathFile
	 * @param privateKeyPassword 
	 * @param userId 
	 * @return hazelcast instance
	 * @throws Exception
	 */
	public static final HazelcastInstance getInstance(String url, String envPassword, String privateKeyPathFile, String privateKeyPassword, String userId) throws Exception {
		String groupName = HttpUtil.getGroupName(url);

		// creates a client configuration for Hazelcast
		ClientConfig clientConfig = new ClientConfig();

		// sets the group name (received by http call) and sets the constant
		// password
		clientConfig.getGroupConfig().setName(groupName).setPassword(envPassword);

		// connect to Hazelcast using the complete list of current members
		clientConfig.addAddress(HttpUtil.getMembers(url));

		// if properties are not empyt, sets up SocketInterceptor.
		if (privateKeyPathFile != null) {
			SubmitInterceptor myClientSocketInterceptor = new SubmitInterceptor(privateKeyPathFile, privateKeyPassword, userId);
			clientConfig.setSocketInterceptor(myClientSocketInterceptor);
		}
		// creates a new Client instance of Hazelcast
		return HazelcastClient.newHazelcastClient(clientConfig);
	}

}