/**
    JEM, the BEE - Job Entry Manager, the Batch Execution Environment
    Copyright (C) 2012, 2013   LucaC
    This program is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program.  If not, see <http://www.gnu.org/licenses/>.
*/
package org.pepstock.jem.ant.validator.groovy;

import java.io.File;

import javax.script.ScriptEngine;
import javax.script.ScriptEngineManager;
import javax.script.ScriptException;
import javax.xml.bind.ValidationException;

import org.pepstock.jem.ant.AntJcl;

/**
 * @author LucaC
 * @version 1.0
 * 
 */
public class GroovyValidator {

	/**
	 * 
	 */
	public GroovyValidator() {
		// Emtpy
	}

	/**
	 * Validate the AntJcl using a custom xslt.
	 * 
	 * @param jcl the jcl
	 * @param inGroovy the groovy script file used to validate the AntJcl
	 * @throws ValidationException the validation exception
	 */
	public void validate(AntJcl jcl, String inGroovy) throws ValidationException {

		if (jcl == null)
			throw new ValidationException("the jcl to validate is null");

		if (!(new File(inGroovy)).exists())
			throw new ValidationException("the custom validator " + inGroovy + " don't exist");

		GroovyValidator gw = new GroovyValidator();

		gw.transform(jcl.getContent(), inGroovy);

	}

	/**
	 * Transform.
	 * 
	 * @param inXmlContent the in xml content
	 * @param inGroovyFile the in groovy file
	 * @throws ValidationException the validation exception
	 */
	private void transform(String inXmlContent, String inGroovyFile) throws ValidationException {
		try {
			ScriptEngineManager factory = new ScriptEngineManager();
			ScriptEngine engine = factory.getEngineByName("groovy");

			engine.put("first", "HELLO");
			engine.put("second", "world");
			System.out.println(engine.eval("first.toLowerCase() + second.toUpperCase()"));
		} catch (ScriptException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		}
	}
}