/**
    JEM, the BEE - Job Entry Manager, the Batch Execution Environment
    Copyright (C) 2012, 2013   Andrea "Stock" Stocchero
    This program is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program.  If not, see <http://www.gnu.org/licenses/>.
*/
package org.pepstock.jem.ant.tasks.managers;

import java.util.ArrayList;
import java.util.HashMap;

import org.pepstock.jem.ant.tasks.Procedure;
import org.pepstock.jem.ant.tasks.ProcedureDefinition;


/**
 * Singleton that contains all PROCEDURE defined inside of ANT JCL.<br>
 * It contains both definition and instances.<br>
 * PROCEDURE is new task which can define a task, container of others.
 * 
 * @author Andrea "Stock" Stocchero
 * @version 1.0	
 *
 */
public class ProceduresContainer {
	
	private static ProceduresContainer INSTANCE = null;
	
	private HashMap<String, ProcedureDefinition> proceduresDefinitions = new HashMap<String, ProcedureDefinition>();
	
	private ArrayList<Procedure> procedures = new ArrayList<Procedure>();

	/**
	 * Singleton, emtpy constructor
	 */
	private ProceduresContainer() {
	}
	
	/**
	 * Returns the singleton instance
	 * @return singleton instance
	 */
	public static synchronized ProceduresContainer getInstance(){
		if  (INSTANCE == null){
			INSTANCE = new ProceduresContainer();
		}
		return INSTANCE;
	}

	/**
	 * Returns all procedure definitions 
	 * @return the proceduresDefinitions
	 */
	public HashMap<String, ProcedureDefinition> getProceduresDefinitions() {
		return proceduresDefinitions;
	}

	/**
	 * Sets all procedure definitions
	 * @param proceduresDefinitions the proceduresDefinitions to set
	 */
	public void setProceduresDefinitions(HashMap<String, ProcedureDefinition> proceduresDefinitions) {
		this.proceduresDefinitions = proceduresDefinitions;
	}

	/**
	 *  Returns all procedures instances 
	 * @return the procedures
	 */
	public ArrayList<Procedure> getProcedures() {
		return procedures;
	}

	/**
	 * Sets all procedures instances
	 * @param procedures the procedures to set
	 */
	public void setProcedures(ArrayList<Procedure> procedures) {
		this.procedures = procedures;
	}
	
	

}