/**
    JEM, the BEE - Job Entry Manager, the Batch Execution Environment
    Copyright (C) 2012, 2013   Andrea "Stock" Stocchero
    This program is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program.  If not, see <http://www.gnu.org/licenses/>.
*/
package org.pepstock.jem.ant.tasks;

import java.lang.management.ManagementFactory;
import java.util.Collection;

import org.apache.tools.ant.launch.Launcher;
import org.pepstock.jem.ant.AntMessage;
import org.pepstock.jem.node.rmi.TasksDoor;
import org.pepstock.jem.node.security.Role;
import org.pepstock.jem.util.Parser;
import org.pepstock.jem.util.rmi.RegistryLocator;
import org.pepstock.jem.util.rmi.RmiKeys;
/**
 * Class not used. Is a wrapper of Launcher of ANT.
 * 
 * @author Andrea "Stock" Stocchero
 * @version 1.0	
 *
 */
public class AntLauncher {
	
	/**
	 * @param args
	 * @throws Exception 
	 */
	public static void main(String[] args) throws Exception{
		// get port number from env var
		// AntTask has passed and set this information (MUST)
		String port = System.getProperty(RmiKeys.JEM_RMI_PORT);
		// creates RMI connection with localhost (default) and using
		// port number.
		// if port is null or not a number, -1 is return and a RMI
		// Exception will occur
		RegistryLocator locator = new RegistryLocator(Parser.parseInt(port, -1));
		// check the taskdoor object is binded, if not, a exception
		// occurs
		if (locator.hasRmiObject(TasksDoor.NAME)) {
			// gets remote object
			TasksDoor door = (TasksDoor) locator.getRmiObject(TasksDoor.NAME);
			// send to JEM node the current process id.
			// uses JMX implementation of JDK.
			// BE CAREFUL! Not all JVM returns the value in same format
			// receives all roles for job user and stores in a static
			// reference
			// of realm
			Collection<Role> myroles = door.setJobStarted(ManagementFactory.getRuntimeMXBean().getName());
			// check if is already instantiated. If yes, does nothing
			if (System.getSecurityManager() == null) {
				System.setSecurityManager(new AntBatchSecurityManager(myroles));
			} else {
				throw new Exception(AntMessage.JEMA039E.toMessage().getMessage());
			}
		} else {
			throw new Exception(AntMessage.JEMA038E.toMessage().getFormattedMessage(TasksDoor.NAME));
		}
		Launcher.main(args);
	}

}