/**
    JEM, the BEE - Job Entry Manager, the Batch Execution Environment
    Copyright (C) 2012, 2013   Alessandro Zambrini
    This program is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program.  If not, see <http://www.gnu.org/licenses/>.
*/
package org.pepstock.catalog.gdg;

import org.pepstock.jem.log.Message;
import org.pepstock.jem.log.MessageInterface;

/**
 * It is an enumeration containing all the messages about JEM GDG. <br>
 * It is a list of <code>GDGMessage</code>. <br> 
 * Each <code>GDGMessage</code> in the list corresponds to a <code>Message</code>. <br>
 * It implements {@link MessageInterface}
 * 
 * @see Message
 * @author Alessandro Zambrini
 * @version 1.0	
 *
 */
public enum GDGMessage implements MessageInterface{
	
	/**
	 * "dd={0}, dsn={1} doesn't exist.", Message.ERROR
	 */
	JEMD001E(1, "dd={0}, dsn={1} doesn't exist.", Message.ERROR),

	/**
	 * "dd={0}, dsn={1} Offset greater than 0 and not allowed in {2}", Message.ERROR
	 */
	JEMD002E(2, "dd={0}, dsn={1} Offset greater than 0 and not allowed in {2}", Message.ERROR),

	/**
	 * "dd={0}, dsn={1} Offset equals or less than 0 and not allowed in NEW.", Message.ERROR
	 */
	JEMD003E(3, "dd={0}, dsn={1} Offset equals or less than 0 and not allowed in NEW.", Message.ERROR),

	/**
	 * "dd={0}, dsn={1} exists.", Message.ERROR
	 */
	JEMD004E(4, "dd={0}, dsn={1} exists.", Message.ERROR),
	
	/**
	 * "Relative position {0} is too high.", Message.ERROR
	 */
	JEMD005E(5, "Relative position {0} is too high.", Message.ERROR),
	
	/**
	 * "File is null.", Message.ERROR
	 */
	JEMD006E(6, "File is null.", Message.ERROR),
	
	/**
	 * "{0} already exists.", Message.ERROR
	 */
	JEMD007E(7, "{0} already exists.", Message.ERROR),
	
	/**
	 * "{0} unable to create generation 0.", Message.ERROR
	 */
	JEMD008E(8, "{0} unable to create generation 0.", Message.ERROR),	
	
	/**
	 * "{0} unable to create directories.", Message.ERROR
	 */
	JEMD009E(9, "{0} unable to create directories.", Message.ERROR),	
	
	/**
	 * "{0}.", Message.ERROR
	 */
	JEMD010E(10, "{0}.", Message.ERROR),
	
	/**
	 * "{0} is not a directory.", Message.ERROR
	 */
	JEMD011E(11, "{0} is not a directory.", Message.ERROR),
	
	/**
	 * "Last Generation is not an Integer: {0}.", Message.ERROR
	 */
	JEMD012E(12, "Last Generation is not an Integer: {0}.", Message.ERROR),
	
	/**
	 * "Last Generation is not setted.", Message.ERROR
	 */
	JEMD013E(13, "Last Generation is not setted.", Message.ERROR);
	
//	/**
//	 * "CLEANUP command syntax error: {0}.", Message.ERROR
//	 */
//	JEMD014E(14, "CLEANUP command syntax error: {0}.", Message.ERROR),
//	
//	/**
//	 * "Data Mount Point is null.", Message.ERROR
//	 */
//	JEMD015E(15, "Data Mount Point is null.", Message.ERROR),
//	
//	/**
//	 * "DDname '{0}' not found!", Message.ERROR
//	 */
//	JEMD016E(16, "DDname '{0}' not found!", Message.ERROR),
//	
//	/**
//	 * "DEFINE command syntax error: {0}.", Message.ERROR
//	 */
//	JEMD017E(17, "DEFINE command syntax error: {0}.", Message.ERROR),
//	
//	/**
//	 * "REBUILD command syntax error: {0}.", Message.ERROR
//	 */
//	JEMD018E(18, "REBUILD command syntax error: {0}.", Message.ERROR),
//	
//	/**
//	 * "GDG unknown command: {0}.", Message.ERROR
//	 */
//	JEMD019E(19, "GDG unknown command: {0}.", Message.ERROR);
	
	/**
	 * Specific message code identifier for <code>GDGMessage</code>. 
	 * It will be displayed in the log.
	 */
	private final static String MESSAGE_ID = "D";
	
	/**
	 * The {@link Message} created in the constructor corresponding to an instance of <code>GDGMessage</code>. 
	 * @see Message
	 */
	private Message message;
	
	/**
	 * Constructor. It builds a <code>Message</code>. <br>
	 * This method uses the same parameter of the <code>Message</code> constructor
	 * and the specific ID: {@link #MESSAGE_ID}.
	 * 
	 * @param code identifier ID
	 * @param msg string do display. Could contain variables, resolved at runtime
	 * @param level severity of log message
	 * @see Message
	 */
	private GDGMessage(int code, String messageContent, int level){
		this.message = new Message(code, MESSAGE_ID, messageContent, level);
	}
	
	/**
	 * It returns the {@link Message} corresponding to an <code>GDGMessage</code> instance.
	 * @return the {@link Message} corresponding to an <code>GDGMessage</code> instance.
	 */
	@Override
	public Message toMessage(){
		return this.message;
	}

}