var RESULT = '';

/**
 * Extracts the OS type
 */
var osName = SYSINFO.getSystemProperties().getProperty('os.name');

if (osName.contains('Windows')){
	RESULT += "Windows,";	
} else if (osName.contains('Linux')){
	RESULT += "Linux,";
} else if (osName.contains('Mac')){
	RESULT += "MacOS,";
} else if (osName.contains('Solaris')){
	RESULT += "Solaris,";
} else if (osName.contains('HP')){
	RESULT += "HPUX,";
} else if (osName.contains('AIX')){
	RESULT += "AIX,";	
} else {
	RESULT += "AnyOS,";
}

var hostnames = SYSINFO.getNetworkProperties().getProperty('hostnames');
if (hostnames != null)
	RESULT += hostnames+", ";

/**
 * Computes 80% of free memory, in slot of 128MB
 */
var freemem = SYSINFO.getRuntimeProperties().getProperty('freeMemory');
freemem = freemem / 1024 / 1024 * 0.80;
MEMORY = Math.min(Math.max(Math.floor(freemem / 64) * 64, 64), 1024);
RESULT += (MEMORY+"MB")
