/*******************************************************************************
 * Copyright (c) 2012-2013 pepstock.org.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors:
 *     Enrico - initial API and implementation
 ******************************************************************************/
package org.pepstock.jem.plugin.views.tabbedQueues;

import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.swt.SWT;
import org.eclipse.swt.custom.CTabItem;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.pepstock.jem.plugin.views.JobColumnSorter;
import org.pepstock.jem.plugin.views.JobLabelProvider;


/**
 * @author Andrea "Stock" Stocchero
 *
 */
public abstract class QueueTab {

	private Composite composite;
	private TableViewer viewer;
	private CTabItem tab;
	private Text number;
	public static final int OK=0,WRN=1,ERR=2;

	public QueueTab(Composite parent, int style, TabbedQueueView view, int tot) {
		tab = new CTabItem(view.getTabFolder(),style);
		composite = new Composite(parent, style);
		GridLayout layout = new GridLayout(3, false);
		composite.setLayout(layout);
		view.addSearch(composite, this);
		viewer = new TableViewer(composite,style);
		
		Label numberLabel = new Label(composite,SWT.NONE);
		numberLabel.setText("&Total Jobs: ");
		numberLabel.getShell().setBackgroundMode(SWT.INHERIT_DEFAULT);
		number = new Text(composite, SWT.NONE);
		number.setLayoutData(new GridData(GridData.FILL_HORIZONTAL));
		number.setText(""+tot);
		number.setEditable(false);
		number.getShell().setBackgroundMode(SWT.INHERIT_DEFAULT);
		
	}

	protected void setTotal(int tot){
		number.setText(""+tot);
	}
	
	public Composite getComposite(){
		return composite;
	}

	public TableViewer getViewer(){
		return viewer;
	}
	
	public CTabItem getTab() {
		return tab;
	}

	public Shell getShell(){
		return getViewer().getControl().getShell();
	}
	
	public void showMessage(String title, String message, int type){
		final String tit = title;
		final String ms = message;
		final int t = type;
		 Display.getDefault().asyncExec(new Runnable() {
		      public void run() {
		switch (t) {
		case OK:
			MessageDialog.openInformation(getShell(), tit, ms);
			break;
		case WRN:
			MessageDialog.openWarning(getShell(), tit, ms);
			break;
		case ERR:
			MessageDialog.openError(getShell(), tit, ms);
			break;

		default:
			MessageDialog.openInformation(getShell(), tit, ms);
			break;
		}
		      }
		   });
	}
	/**
	 * The ID of the view as specified by the extension.
	 */

	public abstract void refresh(String filter);

	public abstract void createColumns(TabbedQueueView view);

	public abstract JobLabelProvider getLabelProvider();

    public abstract JobColumnSorter getColumnSorter();
    
    public abstract String getName();

}
