/*******************************************************************************
 * Copyright (c) 2012-2013 pepstock.org.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors:
 *     Enrico - initial API and implementation
 ******************************************************************************/
package org.pepstock.jem.plugin.views.running;

import java.util.ArrayList;
import java.util.Collection;

import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.pepstock.jem.Job;
import org.pepstock.jem.gwt.server.rest.entities.Jobs;
import org.pepstock.jem.plugin.Client;
import org.pepstock.jem.plugin.UserNotLoggedException;
import org.pepstock.jem.plugin.preferences.PreferenceNotFoundException;
import org.pepstock.jem.plugin.views.JobColumnSorter;
import org.pepstock.jem.plugin.views.JobLabelProvider;
import org.pepstock.jem.plugin.views.tabbedQueues.QueueTab;
import org.pepstock.jem.plugin.views.tabbedQueues.TabbedQueueView;

public class RunningQueueTab extends QueueTab {

	public RunningQueueTab(Composite parent, int style, TabbedQueueView view) {
		super(parent, style, view, 0);
		getTab().setText(getName());
		getTab().setToolTipText(getName()+" queue");
		getTab().setControl(getComposite());
	}
	/**
	 * The ID of the view as specified by the extension.
	 */
	public static final String ID = RunningQueueTab.class.getName();
	private String name = "Running";
	private String[] titles = {"Name", "Type", "User", "Step", "Domain", "Affinity", "Running time", "Memory (MB)", "Member", "Process ID"};
	private int[] bounds = {100, 100, 100, 100, 100, 100, 100, 100, 100, 100 };

	private static final RunningLabelProvider labelProvider = new RunningLabelProvider();
	private static final RunningColumnSorter columnSorter = new RunningColumnSorter();
	
	/* (non-Javadoc)
	 * @see jemplugin.views.JobViewPart#refresh(java.lang.String)
	 */
    @Override
    public void refresh(String filter) {
		final String flt = filter;
		org.eclipse.core.runtime.jobs.Job job = new org.eclipse.core.runtime.jobs.Job(
				"Searching for " + filter) {
			@Override
			protected IStatus run(IProgressMonitor monitor) {
				Jobs jobs = null;
				monitor.beginTask("", IProgressMonitor.UNKNOWN);
				try {
					jobs = Client.getInstance().refreshRunning(flt);
					final Collection<Job> data = (jobs != null && jobs
							.getJobs() != null) ? jobs.getJobs()
							: new ArrayList<Job>();
					Display.getDefault().asyncExec(new Runnable() {
						public void run() {
							getViewer().setInput(data);
							setTotal(data.size());
						}
					});
				} catch (PreferenceNotFoundException e) {
					showMessage("Warning", e.getMessage(), QueueTab.WRN);
				} catch (UserNotLoggedException e) {
					showMessage("Warning", e.getMessage(), QueueTab.WRN);
				} catch (Exception e) {
					showMessage("Error", e.getMessage(), QueueTab.ERR);
				}
				monitor.done();
				return Status.OK_STATUS;
			}
		};
		job.setPriority(org.eclipse.core.runtime.jobs.Job.SHORT);
		job.schedule();
    }
	/* (non-Javadoc)
	 * @see jemplugin.views.JobViewPart#createColumns()
	 */
    @Override
    public void createColumns(TabbedQueueView view) {
		for (int i = 0; i < bounds.length; i++) {
			view.createTableViewerColumn(titles[i], bounds[i], i, getViewer());
		}
		
	}
	/* (non-Javadoc)
	 * @see jemplugin.views.JobViewPart#getLabelProvider()
	 */
    @Override
    public JobLabelProvider getLabelProvider() {
    	return labelProvider;
    }
	/* (non-Javadoc)
	 * @see jemplugin.views.JobViewPart#getColumnSorter()
	 */
    @Override
    public JobColumnSorter getColumnSorter() {
	    return columnSorter;
    }
	public String getName() {
		return name;
	}
	public void setName(String name) {
		this.name = name;
	}
    

}
