/*******************************************************************************
 * Copyright (c) 2012-2013 pepstock.org.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors:
 *     Enrico - initial API and implementation
 ******************************************************************************/
package org.pepstock.jem.plugin.views.running;


import java.util.Date;

import org.pepstock.jem.Job;
import org.pepstock.jem.gwt.client.commons.TimeDisplayUtils;
import org.pepstock.jem.plugin.views.JobLabelProvider;

public class RunningLabelProvider extends JobLabelProvider {

	public String getColumnText(Object obj, int index) {
		Job j = (Job) obj;
		Date startedTime = j.getStartedTime();
		String rt = TimeDisplayUtils.getReadableTimeDiff(startedTime);
		switch (index) {
		case 0:
			return j.getName();
		case 1:
			return j.getJcl().getType();
		case 2:
			return j.getUser();
		case 3:
			return j.getCurrentStep().getName();
		case 4:
			return j.getJcl().getDomain();
		case 5:
			return j.getJcl().getAffinity();
		case 6:
			return rt;
		case 7:
			return String.valueOf(j.getJcl().getMemory());
		case 8:
			return j.getMemberLabel();
		case 9:
			return j.getProcessId();
		default:
			return null;
		}
	}
}
