/*******************************************************************************
 * Copyright (c) 2012-2013 pepstock.org.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors:
 *     Enrico - initial API and implementation
 ******************************************************************************/
package org.pepstock.jem.plugin.views.output;


import org.pepstock.jem.Job;
import org.pepstock.jem.plugin.views.JobLabelProvider;

public class OutputLabelProvider extends JobLabelProvider {

	public String getColumnText(Object obj, int index) {
		Job j = (Job) obj;
		switch (index) {
		case 0:
			return j.getName();
		case 1:
			return j.getJcl().getType();
		case 2:
			return j.getJcl().getEnvironment();
		case 3:
			return j.getJcl().getDomain();
		case 4:
			return j.getJcl().getAffinity();
		case 5:
			return getDateFormatter().format(j.getEndedTime());
		case 6:
			return String.valueOf(j.getResult().getReturnCode());
		case 7:
			return String.valueOf(j.getJcl().getPriority());
		case 8:
			return String.valueOf(j.getJcl().isHold());
		case 9:
			return j.getMemberLabel();
		default:
			return null;
		}
	}
}
