/*******************************************************************************
 * Copyright (c) 2012-2013 pepstock.org.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors:
 *     Enrico - initial API and implementation
 ******************************************************************************/
package org.pepstock.jem.plugin.views.outline.model;

import java.util.ArrayList;
import java.util.List;

import org.pepstock.jem.OutputListItem;
import org.pepstock.jem.gwt.server.rest.entities.JobOutputTreeContent;

public class OutTree {

	public static final String JOB_INFO = "job infos";
	public static final String JOB_JCL = "jcl";
	public static final String ANT_JCL = "ant_buildfile.gif";
	public static final String LOG_FILE = "file_obj.gif";
	public static OutTree INSTANCE = null;

	public static OutTree getInstance(){
		if(INSTANCE==null);
			INSTANCE = new OutTree();
		return INSTANCE;
	}
	
	public List<Category> getCategories(JobOutputTreeContent outputTree) {
		List<Category> categories = new ArrayList<Category>();
		Category category = new Category();
		//tolto su richista di stock
//		category.setName("General");
//		categories.add(category);
//		Out out = new Out("Job general informations",JOB_INFO);
//		category.getOuts().add(out);

		category = new Category();
		category.setName("JCL");
		category.setImage(ANT_JCL);
		categories.add(category);
		Out out = new Out("Submitted JCL",JOB_JCL);
		category.getOuts().add(out);
		

		category = new Category();
		category.setName("Output");
		category.setImage(LOG_FILE);
		categories.add(category);
		for(int i=0;outputTree.getFirstLevelItems()!=null && i<outputTree.getFirstLevelItems().size();i++){
			out = new Out(outputTree.getFirstLevelItems().get(i).getLabel(),outputTree.getFirstLevelItems().get(i).getFileRelativePath());
			out.setOutItem(outputTree.getFirstLevelItems().get(i));
			category.getOuts().add(out);
		}
		for (String key : outputTree.getSecondLevelItems().keySet()) {
			Category subCategory = new Category();
			subCategory.setName(key);
			for (OutputListItem item : outputTree.getSecondLevelItems().get(key)) {
				out = new Out(item.getLabel(),item.getFileRelativePath());
				out.setOutItem(item);
				subCategory.getOuts().add(out);
			}
			category.getCats().add(subCategory);
		}

		
		return categories;
	}

}
