/*******************************************************************************
 * Copyright (c) 2012-2013 pepstock.org.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors:
 *     Enrico - initial API and implementation
 ******************************************************************************/
package org.pepstock.jem.plugin.views.outline.dialog;

import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.swt.SWT;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.TabFolder;
import org.eclipse.swt.widgets.TabItem;
import org.eclipse.swt.widgets.Text;
import org.pepstock.jem.Jcl;
import org.pepstock.jem.Job;
import org.pepstock.jem.util.DateFormatter;

public class JobPropertiesDialog extends Dialog{

	private TabFolder folder;

	private TabItem jobTab;
	private Text name;
	private Text userid;
	private Text processId;
	private Text submitted;
	private Text started;
	private Text ended;
	private Text currentStep;
	private Text result;
	
	private TabItem jclTab;
	private Text environment;
	private Text domain;
	private Text affinities;
	private Text memory;
	private Text priority;
	private Button hold;
	private Text node;
		
	private Job job;
	
	private final String DATE_FORMAT = "dd/MM/yyyy hh:mm:ss.SSSS"; 

	public JobPropertiesDialog(Shell parentShell, Job template) {
		super(parentShell);
		setShellStyle(getShellStyle()|SWT.RESIZE);
		this.job = template;
	}
	
	protected void createButtonsForButtonBar(Composite parent) {
//		super.createButtonsForButtonBar(parent);
	}
		
		protected Control createDialogArea(Composite parent) {
			getShell().setText("Job Informations "+job.getName());
			Composite main = new Composite(parent, SWT.NONE);
			GridLayout mainLayout = new GridLayout(1, false);
			
			main.setLayout(mainLayout);
			main.setLayoutData(new GridData(GridData.FILL_BOTH));

			folder = new TabFolder(main, SWT.NONE);
			folder.setLayoutData(new GridData(GridData.FILL_BOTH));
			jobTab = new TabItem(folder, SWT.NONE);
			jobTab.setText("Job");
			jclTab = new TabItem(folder, SWT.NONE);
			jclTab.setText("Jcl");

			Composite jobComposite = new Composite(folder, SWT.NONE);
			Composite jclComposite = new Composite(folder, SWT.NONE);
			
			GridLayout compLayout = new GridLayout(2, false);

			jobComposite.setLayout(compLayout);
			jobComposite.setLayoutData(new GridData(GridData.FILL_BOTH));

			jclComposite.setLayout(compLayout);
			jclComposite.setLayoutData(new GridData(GridData.FILL_BOTH));

			createJobTab(jobComposite);
			createJclTab(jclComposite);
			
			jobTab.setControl(jobComposite);
			jclTab.setControl(jclComposite);
			
			return main;
		}
		
		private void createJobTab(Composite composite){
			Label nameLabel = new Label(composite, SWT.NONE);
			nameLabel.setText("&Name");
			name = new Text(composite, SWT.BORDER);
			name.setLayoutData(new GridData(GridData.FILL_HORIZONTAL));
			name.setText(nullCheck(job.getName()));
			name.setEditable(false);

			Label useridLabel = new Label(composite, SWT.NONE);
			useridLabel.setText("&Userid");
			userid = new Text(composite, SWT.BORDER);
			userid.setLayoutData(new GridData(GridData.FILL_HORIZONTAL));
			userid.setText(nullCheck(job.getUser()));
			userid.setEditable(false);

			Label processIdLabel = new Label(composite, SWT.NONE);
			processIdLabel.setText("&Process");
			processId = new Text(composite, SWT.BORDER);
			processId.setLayoutData(new GridData(GridData.FILL_HORIZONTAL));
			processId.setText(nullCheck(job.getProcessId()));
			processId.setEditable(false);
			
			Label submittedLabel = new Label(composite, SWT.NONE);
			submittedLabel.setText("&Submitted Date Time");
			submitted = new Text(composite, SWT.BORDER);
			submitted.setLayoutData(new GridData(GridData.FILL_HORIZONTAL));
			submitted.setText(DateFormatter.getDate(job.getSubmittedTime(),DATE_FORMAT));
			submitted.setEditable(false);

			Label startedLabel = new Label(composite, SWT.NONE);
			startedLabel.setText("&Started Date Time");
			started = new Text(composite, SWT.BORDER);
			started.setLayoutData(new GridData(GridData.FILL_HORIZONTAL));
			started.setText(DateFormatter.getDate(job.getStartedTime(),DATE_FORMAT));
			started.setEditable(false);

			Label endedLabel = new Label(composite, SWT.NONE);
			endedLabel.setText("&Ended Date Time");
			ended = new Text(composite, SWT.BORDER);
			ended.setLayoutData(new GridData(GridData.FILL_HORIZONTAL));
			ended.setText(DateFormatter.getDate(job.getEndedTime(),DATE_FORMAT));
			ended.setEditable(false);
			
			Label currentStepLabel = new Label(composite, SWT.NONE);
			currentStepLabel.setText("&Current Step");
			currentStep = new Text(composite, SWT.BORDER);
			currentStep.setLayoutData(new GridData(GridData.FILL_HORIZONTAL));
			currentStep.setText(nullCheck(job.getCurrentStep().getName()));
			currentStep.setToolTipText(nullCheck(job.getCurrentStep().getDescritpion()));
			currentStep.setEditable(false);

			Label resultLabel = new Label(composite, SWT.NONE);
			resultLabel.setText("&Result");
			result = new Text(composite, SWT.BORDER);
			result.setLayoutData(new GridData(GridData.FILL_HORIZONTAL));
			result.setText(String.valueOf(job.getResult().getReturnCode()));
			result.setEditable(false);
		}

		private void createJclTab(Composite composite){
			Jcl jcl = job.getJcl();
			Label environmentLabel = new Label(composite, SWT.NONE);
			environmentLabel.setText("&Environment");
			environment = new Text(composite, SWT.BORDER);
			environment.setLayoutData(new GridData(GridData.FILL_HORIZONTAL));
			environment.setText(nullCheck(jcl.getEnvironment()));
			environment.setEditable(false);

			Label domainLabel = new Label(composite, SWT.NONE);
			domainLabel.setText("&Domain");
			domain = new Text(composite, SWT.BORDER);
			domain.setLayoutData(new GridData(GridData.FILL_HORIZONTAL));
			domain.setText(nullCheck(jcl.getDomain()));
			domain.setEditable(false);

			Label affinitiesLabel = new Label(composite, SWT.NONE);
			affinitiesLabel.setText("&Affinities");
			affinities = new Text(composite, SWT.BORDER);
			affinities.setLayoutData(new GridData(GridData.FILL_HORIZONTAL));
			affinities.setText(nullCheck(jcl.getAffinity()));
			affinities.setEditable(false);
			
			Label memoryLabel = new Label(composite, SWT.NONE);
			memoryLabel.setText("&Memory");
			memory = new Text(composite, SWT.BORDER);
			memory.setLayoutData(new GridData(GridData.FILL_HORIZONTAL));
			memory.setText(String.valueOf(jcl.getMemory()));
			memory.setEditable(false);

			Label priorityLabel = new Label(composite, SWT.NONE);
			priorityLabel.setText("&Priority");
			priority = new Text(composite, SWT.BORDER);
			priority.setLayoutData(new GridData(GridData.FILL_HORIZONTAL));
			priority.setText(String.valueOf(jcl.getPriority()));
			priority.setEditable(false);

			Label holdLabel = new Label(composite, SWT.NONE);
			holdLabel.setText("&Hold");
			hold = new Button(composite,SWT.CHECK);
			hold.setSelection(jcl.isHold());
			hold.setEnabled(false);
			
			Label nodeLabel = new Label(composite, SWT.NONE);
			nodeLabel.setText("&Node");
			node = new Text(composite, SWT.BORDER);
			node.setLayoutData(new GridData(GridData.FILL_HORIZONTAL));
			node.setText(nullCheck(job.getMemberLabel()));
			node.setEditable(false);

		}
		
		private String nullCheck(String s){
			if(s==null || "null".equals(s))
				return "";
			return s;
		}

}
