/*******************************************************************************
 * Copyright (c) 2012-2013 pepstock.org.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors:
 *     Enrico - initial API and implementation
 ******************************************************************************/
package org.pepstock.jem.plugin.views.outline;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;

import org.eclipse.core.filesystem.EFS;
import org.eclipse.core.filesystem.IFileStore;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.dnd.DND;
import org.eclipse.swt.dnd.DragSourceEvent;
import org.eclipse.swt.dnd.DragSourceListener;
import org.eclipse.swt.dnd.FileTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.IEditorDescriptor;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.ide.FileStoreEditorInput;
import org.pepstock.jem.Job;
import org.pepstock.jem.OutputFileContent;
import org.pepstock.jem.gwt.server.rest.entities.JobOutputListArgument;
import org.pepstock.jem.gwt.server.rest.entities.JobOutputTreeContent;
import org.pepstock.jem.plugin.Client;
import org.pepstock.jem.plugin.editor.StringEditorInput;
import org.pepstock.jem.plugin.views.JemViewBroker;
import org.pepstock.jem.plugin.views.JemViewPart;
import org.pepstock.jem.plugin.views.outline.dialog.JobPropertiesDialog;
import org.pepstock.jem.plugin.views.outline.model.Out;
import org.pepstock.jem.plugin.views.outline.model.OutTree;

public class OutlineView extends JemViewPart {

	/**
	 * The ID of the view as specified by the extension.
	 */
	public static final String ID = OutlineView.class.getName();
	private JobOutputTreeContent data;
	private Job job;
	private static final OutlineLabelProvider labelProvider = new OutlineLabelProvider();
	private static final OutlineContentProvider contetProvider = new OutlineContentProvider();
	private TreeViewer tree;
	
	public void setData(JobOutputTreeContent data, Job job){
		this.data = data;
		this.setJob(job);
		setPartName(job.getName()+" Outline View");
		tree.setInput(data);
	}
	
	public OutlineView() {
		JemViewBroker.getInstance().register(this);
	}
	
	@Override
	public void createPartControl(Composite parent) {
		tree = new TreeViewer(parent); 
		tree.setContentProvider(contetProvider); 
		tree.setLabelProvider(labelProvider); 
		tree.setInput(data);	
		tree.setAutoExpandLevel(2);
		int operations = DND.DROP_COPY| DND.DROP_MOVE;
		Transfer[] transferTypes = new Transfer[]{FileTransfer.getInstance()};
		tree.addDragSupport(operations, transferTypes , new DragSourceListener() {
			
			  @Override
			  public void dragFinished(DragSourceEvent event) {
//			    System.out.println("Finshed Drag");
			  }

			  @Override
			  public void dragSetData(DragSourceEvent event) {
			    // Here you do the convertion to the type which is expected.
			    IStructuredSelection selection = (IStructuredSelection) tree.getSelection();
		        Object selectedNode = selection.getFirstElement();
		        if(selectedNode instanceof Out){
		        	Out out = (Out) selectedNode;
		        	if(OutTree.JOB_JCL.equals(out.getDescription())){
		        		 FileOutputStream fos = null;
				    		try {
				    			String tDir = System.getProperty("java.io.tmpdir");
				    			File file = new File(tDir+getJob().getName()+".xml");
				    			fos = new FileOutputStream(file);
				    			fos.write(getJob().getJcl().getContent().getBytes());
				    			fos.close();
				    			if (FileTransfer.getInstance().isSupportedType(event.dataType)) {
			    			      event.data = new String[]{file.getAbsolutePath()}; 
			    			    }
				    		} catch (IOException e) {
				    			if(fos!=null)
				    				try {
				    					fos.close();
				    				} catch (IOException e1) {
				    					e1.printStackTrace();
				    				}
				    			e.printStackTrace();
				    		}
		        	 }
		        }
			  }

			  @Override
			  public void dragStart(DragSourceEvent event) {
//			    System.out.println("Start Drag");
			  }
		});
		tree.addDoubleClickListener(new IDoubleClickListener() {

		      @Override
		      public void doubleClick(DoubleClickEvent event) {
		        TreeViewer viewer = (TreeViewer) event.getViewer();
		        IStructuredSelection thisSelection = (IStructuredSelection) event.getSelection();
		        Object selectedNode = thisSelection.getFirstElement();
		        if(selectedNode instanceof Out){
		        	Out out = (Out)selectedNode;
		        	if(OutTree.JOB_INFO.equals(out.getDescription())){
			        	//se general popup
		        		JobPropertiesDialog jp = new JobPropertiesDialog(getSite().getShell(),job);
		        		jp.open();
		        	}
		        	else if(OutTree.JOB_JCL.equals(out.getDescription())){
			        	//se jcl apro
		        		FileOutputStream fos = null;
		        		try {
		        			String tDir = System.getProperty("java.io.tmpdir");
		        			File file = new File(tDir+getJob().getName()+".xml");
		        			fos = new FileOutputStream(file);
		        			fos.write(getJob().getJcl().getContent().getBytes());
		        			fos.close();
		        			IPath ipath = new Path(file.getAbsolutePath());
		        			IFileStore fileLocation = EFS.getLocalFileSystem().getStore(ipath);
		        			IEditorDescriptor desc = PlatformUI.getWorkbench().getEditorRegistry().getDefaultEditor(file.getName());
							getSite().getWorkbenchWindow().getActivePage().openEditor(new FileStoreEditorInput(fileLocation),desc.getId());
//							IWorkbenchPage ps = getSite().getWorkbenchWindow().getActivePage();
//		        			System.out.println(desc.getId());
						} catch (PartInitException e) {
							MessageDialog.openError(getSite().getShell(), "Error", "Error while loading JCL, cause: "+e.getMessage());
							e.printStackTrace();
						} catch (IOException e) {
							if(fos!=null)
								try {
									fos.close();
								} catch (IOException e1) {
									e1.printStackTrace();
								}
							MessageDialog.openError(getSite().getShell(), "Error", "Error while loading JCL, cause: "+e.getMessage());
							e.printStackTrace();
						}
		        	}
		        	else{
			        	//se log apro e carico
		        		JobOutputListArgument arg = new JobOutputListArgument();
		        		arg.setItem(out.getOutItem());
		        		try {
							OutputFileContent ofc = Client.getInstance().getOutputFileContent(arg);
							getSite().getWorkbenchWindow().getActivePage().openEditor(new StringEditorInput(ofc.getContent(), out.getSummary()), "org.eclipse.ui.DefaultTextEditor");
							
						} catch (Exception e) {
							MessageDialog.openError(getSite().getShell(), "Error", "Error while loading log file, cause: "+e.getMessage());
						}
		        	}
		        }else{
			        viewer.setExpandedState(selectedNode,
				            !viewer.getExpandedState(selectedNode));
		        }
		      }
		    });
		makeActions();
		hookContextMenu();
		contributeToActionBars();
	}

	public Viewer getViewer(){
		return tree;
	}
	
	@Override
	public void setFocus() {
		tree.getControl().setFocus();
	}



	public void setJob(Job job) {
		this.job = job;
	}



	public Job getJob() {
		return job;
	} 

}
