/*******************************************************************************
 * Copyright (c) 2012-2013 pepstock.org.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors:
 *     Enrico - initial API and implementation
 ******************************************************************************/
package org.pepstock.jem.plugin.views.outline;


import java.net.URL;

import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.Path;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.swt.graphics.Image;
import org.osgi.framework.Bundle;
import org.osgi.framework.FrameworkUtil;
import org.pepstock.jem.plugin.views.outline.model.Category;
import org.pepstock.jem.plugin.views.outline.model.Out;

public class OutlineLabelProvider extends LabelProvider {

	public String getText(Object element) {
		if (element instanceof Category) {
		      Category category = (Category) element;
		      return category.getName();
		    }
		    return ((Out) element).getSummary();
	}

	@Override
	public Image getImage(Object element) {
		if (element instanceof Category) {
		      Category category = (Category) element;
		      if(category.getImage()!=null)
		    	  return getImage(category.getImage());
		    }
		    return null;
	}
	
	 private static Image getImage(String file) {
		    Bundle bundle = FrameworkUtil.getBundle(OutlineLabelProvider.class);
		    URL url = FileLocator.find(bundle, new Path("icons/" + file), null);
		    ImageDescriptor image = ImageDescriptor.createFromURL(url);
		    return image.createImage();

		  } 
}
