/*******************************************************************************
 * Copyright (c) 2012-2013 pepstock.org.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors:
 *     Enrico - initial API and implementation
 ******************************************************************************/
package org.pepstock.jem.plugin.views.outline;

import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.Viewer;
import org.pepstock.jem.gwt.server.rest.entities.JobOutputTreeContent;
import org.pepstock.jem.plugin.views.outline.model.Category;
import org.pepstock.jem.plugin.views.outline.model.OutTree;


/**
 * @author Andrea "Stock" Stocchero
 *
 */
public class OutlineContentProvider implements ITreeContentProvider{
	
	public Object[] getElements(Object parent) {
		if(parent != null){
			JobOutputTreeContent ot = (JobOutputTreeContent)parent;
			return OutTree.getInstance().getCategories(ot).toArray();
		}
		return null;
	}

	@Override
	public Object[] getChildren(Object parent) {
		if (parent instanceof Category) {
		      Category category = (Category) parent;
		      Object[] cats = category.getCats().toArray();
		      Object[] outs = category.getOuts().toArray();
		      Object[] all = new Object[cats.length+outs.length];
		      for(int i=0;i<outs.length;i++){
		    	  all[i]=outs[i];
		      }
		      for(int i=0;i<cats.length;i++){
		    	  all[outs.length+i]=cats[i];
		      }
		      return all;
		}
		return null;
	}

	@Override
	public Object getParent(Object children) {
		return null;
	}

	@Override
	public boolean hasChildren(Object element) {
		if (element instanceof Category) {
			return true;
		}
		return false;
	}

	@Override
	public void dispose() {
	}

	@Override
	public void inputChanged(Viewer arg0, Object arg1, Object arg2) {
	}
}

