/*******************************************************************************
 * Copyright (c) 2012-2013 pepstock.org.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors:
 *     Enrico - initial API and implementation
 ******************************************************************************/
package org.pepstock.jem.plugin.views.explorer;


import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.swt.graphics.Image;
import org.eclipse.ui.ISharedImages;
import org.eclipse.ui.PlatformUI;
import org.pepstock.jem.GfsFile;

public class GfsLabelProvider extends LabelProvider {

	private static final Image FILE = PlatformUI.getWorkbench().getSharedImages().getImage(ISharedImages.IMG_OBJ_FILE); //"file_obj.gif";
	private static final Image DIR = PlatformUI.getWorkbench().getSharedImages().getImage(ISharedImages.IMG_OBJ_FOLDER); //"dir.gif";
	
	public String getText(Object element) {
		GfsFile file = (GfsFile) element;
		return file.getName();
	}

	@Override
	public Image getImage(Object element) {
		GfsFile file = (GfsFile) element;
		if (file.isDirectory()) {
	    	  return DIR;
		}else
			return FILE;
	}
	
}
