/*******************************************************************************
 * Copyright (c) 2012-2013 pepstock.org.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors:
 *     Enrico - initial API and implementation
 ******************************************************************************/
package org.pepstock.jem.plugin.views.explorer;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.dnd.DND;
import org.eclipse.swt.dnd.DragSourceEvent;
import org.eclipse.swt.dnd.DragSourceListener;
import org.eclipse.swt.dnd.FileTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.widgets.Composite;
import org.pepstock.jem.GfsFile;
import org.pepstock.jem.gwt.server.rest.entities.GfsFileList;
import org.pepstock.jem.plugin.Client;
import org.pepstock.jem.plugin.editor.StringEditorInput;
import org.pepstock.jem.plugin.views.JemViewBroker;
import org.pepstock.jem.plugin.views.JemViewPart;
import org.pepstock.jem.plugin.views.explorer.model.GfsFileModel;

public class GfsExplorerView extends JemViewPart {

	/**
	 * The ID of the view as specified by the extension.
	 */
	public static final String ID = GfsExplorerView.class.getName();
	private GfsFileList data;
	private static final GfsLabelProvider labelProvider = new GfsLabelProvider();
	private static final GfsContentProvider contetProvider = new GfsContentProvider();
	private TreeViewer tree;

	public GfsExplorerView() throws Exception {
		data = new GfsFileList();
		List<GfsFile> gfsFiles = new ArrayList<GfsFile>();
		String[] names = new String[] { "Data", "Library", "Source", "Class",
				"Binary" };
		for (int i = 0; i < names.length; i++) {
			GfsFileModel dataRoot = new GfsFileModel();
			dataRoot.setDirectory(true);
			dataRoot.setName(names[i]);
			dataRoot.setLongName(".");
			dataRoot.setType(i);
			gfsFiles.add(dataRoot);
		}
		data.setGfsFiles(gfsFiles);
		JemViewBroker.getInstance().register(this);
	}

	public void updateName() {
		String title = getTitle();
		title = title.indexOf('-') != -1 ? title.substring(0,
				title.indexOf('-')) : title;
		String name = Client.getInstance().getCurrentHost();
		name = name == null ? title : title + "-" + name;
		setPartName(name);
	}

	public void setData(GfsFileList data) {
		this.data = data;
		setPartName("GFS Explorer");
		tree.setInput(data);
	}

	@Override
	public void createPartControl(Composite parent) {
		tree = new TreeViewer(parent);
		tree.setContentProvider(contetProvider);
		tree.setLabelProvider(labelProvider);
		tree.setInput(data);
		tree.setAutoExpandLevel(2);
		int operations = DND.DROP_COPY | DND.DROP_MOVE;
		Transfer[] transferTypes = new Transfer[] { FileTransfer.getInstance() };
		tree.addDragSupport(operations, transferTypes,
				new DragSourceListener() {

					@Override
					public void dragSetData(DragSourceEvent event) {
						// Here you do the convertion to the type which is
						// expected.
						IStructuredSelection selection = (IStructuredSelection) tree
								.getSelection();
						Object selectedNode = selection.getFirstElement();
						if (selectedNode instanceof GfsFileModel) {
							GfsFileModel gfsFile = (GfsFileModel) selectedNode;
							if (!gfsFile.isDirectory()) {
								if (GfsFile.DATA != gfsFile.getType())
									return;
								FileOutputStream fos = null;
								try {
									String tDir = System
											.getProperty("java.io.tmpdir");
									File file = new File(tDir
											+ gfsFile.getName());
									fos = new FileOutputStream(file);
									String sfile = Client.getInstance()
											.getGfsFile(gfsFile);
									fos.write(sfile.getBytes());
									fos.close();
									if (FileTransfer.getInstance()
											.isSupportedType(event.dataType)) {
										event.data = new String[] { file
												.getAbsolutePath() };
									}
								} catch (IOException e) {
									if (fos != null)
										try {
											fos.close();
										} catch (IOException e1) {
											e1.printStackTrace();
											MessageDialog.openError(getSite()
													.getShell(),
													"GSF JEM View", e1
															.getMessage());
										}
									e.printStackTrace();
								} catch (Exception e) {
									e.printStackTrace();
									MessageDialog.openError(getSite()
											.getShell(), "GSF JEM View", e
											.getMessage());
								}
							}
						}
					}

					@Override
					public void dragStart(DragSourceEvent event) {
						// TODO Auto-generated method stub
					}

					@Override
					public void dragFinished(
							DragSourceEvent paramDragSourceEvent) {
						// TODO Auto-generated method stub
					}
				});
		tree.addDoubleClickListener(new IDoubleClickListener() {

			@Override
			public void doubleClick(DoubleClickEvent event) {
				TreeViewer viewer = (TreeViewer) event.getViewer();
				IStructuredSelection thisSelection = (IStructuredSelection) event
						.getSelection();
				Object selectedNode = thisSelection.getFirstElement();
				if (selectedNode instanceof GfsFileModel) {
					GfsFileModel file = (GfsFileModel) selectedNode;
					if (file.isDirectory())
						viewer.setExpandedState(selectedNode,
								!viewer.getExpandedState(selectedNode));
					else {
						if (GfsFile.DATA != file.getType())
							return;
						try {
							String sfile = Client.getInstance()
									.getGfsFile(file);
							getSite()
									.getWorkbenchWindow()
									.getActivePage()
									.openEditor(
											new StringEditorInput(sfile, file
													.getName()),
											"org.eclipse.ui.DefaultTextEditor");
						} catch (Exception e) {
							e.printStackTrace();
							MessageDialog.openError(getSite().getShell(),
									"GSF JEM View", e.getMessage());
						}
					}
				} else {
					viewer.setExpandedState(selectedNode,
							!viewer.getExpandedState(selectedNode));
				}
			}
		});
		makeActions();
		hookContextMenu();
		contributeToActionBars();
	}

	@Override
	public void setFocus() {
		tree.getControl().setFocus();
	}

	@Override
	public Viewer getViewer() {
		return tree;
	}

}
