/*******************************************************************************
 * Copyright (c) 2012-2013 pepstock.org.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors:
 *     Enrico - initial API and implementation
 ******************************************************************************/
package org.pepstock.jem.plugin.views.explorer;

import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.widgets.Shell;
import org.pepstock.jem.GfsFile;
import org.pepstock.jem.gwt.server.rest.entities.GfsFileList;
import org.pepstock.jem.plugin.Client;
import org.pepstock.jem.plugin.views.explorer.model.GfsFileModel;


/**
 * @author Andrea "Stock" Stocchero
 *
 */
public class GfsContentProvider implements ITreeContentProvider{
	
	public Object[] getElements(Object parent) {
		if(parent != null){
			GfsFileList gfsFl = (GfsFileList)parent;
			return gfsFl.getGfsFiles().toArray();
		}
		return null;
	}

	@Override
	public Object[] getChildren(Object parent) {
		GfsFileModel file = (GfsFileModel) parent;
		Object[] fileList = null ;
		if(file.isDirectory()){
			try {
				switch (file.getType()) {
				case GfsFile.DATA:
					fileList = Client.getInstance().getGfsFileListData(file.getLongName()).toArray();
					break;
				case GfsFile.LIBRARY:
					fileList = Client.getInstance().getGfsFileListLibrary(file.getLongName()).toArray();
					break;
				case GfsFile.SOURCE:
					fileList = Client.getInstance().getGfsFileListSource(file.getLongName()).toArray();
					break;
				case GfsFile.CLASS:
					fileList = Client.getInstance().getGfsFileListClass(file.getLongName()).toArray();
					break;
				case GfsFile.BINARY:
					fileList = Client.getInstance().getGfsFileListBinary(file.getLongName()).toArray();
					break;

				default:
					break;
				}
				return fileList;
			} catch (Exception e) {
				e.printStackTrace();
				MessageDialog.openError(new Shell(), "GSF JEM View", e.getMessage());
			}
		}
		return null;
	}

	@Override
	public Object getParent(Object children) {
		return null;
	}

	@Override
	public boolean hasChildren(Object element) {
		GfsFileModel file = (GfsFileModel) element;
		if (file.isDirectory()) {
			return true;
		}
		return false;
	}

	@Override
	public void dispose() {
	}

	@Override
	public void inputChanged(Viewer arg0, Object arg1, Object arg2) {
	}
}

