/*******************************************************************************
 * Copyright (c) 2012-2013 pepstock.org.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors:
 *     Enrico - initial API and implementation
 ******************************************************************************/
package org.pepstock.jem.plugin.views;

import java.text.SimpleDateFormat;


import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.swt.graphics.Image;
import org.pepstock.jem.plugin.Activator;

/**
 * @author Andrea "Stock" Stocchero
 *
 */
public abstract class JobLabelProvider extends LabelProvider implements ITableLabelProvider {

	private SimpleDateFormat dateFormatter;

	/**
	 * 
	 */
	public JobLabelProvider() {
		dateFormatter = new SimpleDateFormat(Activator.getDefault().getBundleProperty("datetimeFormat"));
	}

	/**
	 * @return the dateFormatter
	 */
	public SimpleDateFormat getDateFormatter() {
		return dateFormatter;
	}

	public abstract String getColumnText(Object obj, int index);

	public Image getColumnImage(Object obj, int index) {
		return null;
	}
//	public Image getColumnImage(Object obj, int index) {
//		switch (index) {
//		case 0:
//			return getImage(obj);
//		default:
//			return null;
//		}
//	}
//
//	public Image getImage(Object obj) {
//		return PlatformUI.getWorkbench().getSharedImages().getImage(ISharedImages.IMG_OBJ_ELEMENT);
//	}
}
