/*******************************************************************************
 * Copyright (c) 2012-2013 pepstock.org.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors:
 *     Enrico - initial API and implementation
 ******************************************************************************/
package org.pepstock.jem.plugin.views;

import java.util.Comparator;

import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerSorter;
import org.pepstock.jem.Job;

/**
 * @author Andrea "Stock" Stocchero
 *
 */
public abstract class JobColumnSorter extends ViewerSorter implements Comparator<Job> {

	private boolean ascending = true;
	
	private int index = 0;
	
	@Override
	public int compare(Viewer viewer, Object e1, Object e2) {
		if ((e1 instanceof Job) && (e2 instanceof Job)) {
			Job o1 = (Job) e1;
			Job o2 = (Job) e2;
			return compare(o1, o2);
		} else {
			if (isAscending())
				return super.compare(viewer, e1, e2);
			else
				return super.compare(viewer, e2, e1);
		}
	}

	/**
	 * @return the ascending
	 */
	public boolean isAscending() {
		return ascending;
	}



	/**
	 * @param ascending the ascending to set
	 */
	public void setAscending(boolean ascending) {
		this.ascending = ascending;
	}

	/**
	 * @return the index
	 */
	public int getIndex() {
		return index;
	}

	/**
	 * @param index the index to set
	 */
	public void setIndex(int index) {
		this.index = index;
	}

	

}
