package org.pepstock.jem.plugin.views;

import java.net.URL;

import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.Path;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.IWorkbenchActionConstants;
import org.eclipse.ui.part.ViewPart;
import org.osgi.framework.Bundle;
import org.osgi.framework.FrameworkUtil;
import org.pepstock.jem.plugin.Client;
import org.pepstock.jem.plugin.actions.LogOutAction;
import org.pepstock.jem.plugin.actions.SelectEnvAction;
import org.pepstock.jem.plugin.views.outline.OutlineLabelProvider;

public abstract class JemViewPart extends ViewPart{

	protected Action selectEnvAction;
	protected Action logOutAction;
	
	public abstract Viewer getViewer();
	
	public void setFocus() {
		getViewer().getControl().setFocus();
	}

	public void setImage(Image image){
		setTitleImage(image);
	}
	
	public void setImage(String file){
		setTitleImage(getImage(file));
	}

	protected void hookContextMenu() {
		MenuManager menuMgr = new MenuManager("#PopupMenu");
		menuMgr.setRemoveAllWhenShown(true);
		menuMgr.addMenuListener(new IMenuListener() {
			public void menuAboutToShow(IMenuManager manager) {
				JemViewPart.this.fillContextMenu(manager);
			}
		});
		Menu menu = menuMgr.createContextMenu(getViewer().getControl());
		getViewer().getControl().setMenu(menu);
		getSite().registerContextMenu(menuMgr, getViewer());
	}

	public void updateName(){
		String title = getTitle();
		title = title.indexOf('-')!=-1?title.substring(0,title.indexOf('-')):title;
		String name = Client.getInstance().getCurrentHost();
		name = name==null?title:title+"-"+name;
		setPartName(name);
	}

	protected void contributeToActionBars() {
		IActionBars bars = getViewSite().getActionBars();
		fillLocalPullDown(bars.getMenuManager());
		fillLocalToolBar(bars.getToolBarManager());
	}

	private void fillLocalPullDown(IMenuManager manager) {
		manager.add(selectEnvAction);
		manager.add(new Separator());
		manager.add(logOutAction);
	}

	private void fillContextMenu(IMenuManager manager) {
		manager.add(selectEnvAction);
		manager.add(logOutAction);
		// Other plug-ins can contribute there actions here
		manager.add(new Separator(IWorkbenchActionConstants.MB_ADDITIONS));
	}

	private void fillLocalToolBar(IToolBarManager manager) {
		manager.add(selectEnvAction);
		manager.add(logOutAction);
	}

	protected void makeActions() {
		selectEnvAction = new SelectEnvAction(this);
		logOutAction = new LogOutAction(this);
	}

	 protected Image getImage(String file) {
		    Bundle bundle = FrameworkUtil.getBundle(OutlineLabelProvider.class);
		    URL url = FileLocator.find(bundle, new Path("icons/" + file), null);
		    ImageDescriptor image = ImageDescriptor.createFromURL(url);
		    return image.createImage();

	  } 

}
