/*******************************************************************************
 * Copyright (c) 2012-2013 pepstock.org.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors:
 *     Enrico - initial API and implementation
 ******************************************************************************/
package org.pepstock.jem.plugin.views;

import java.util.ArrayList;

import org.eclipse.swt.widgets.Display;

/**
 * @author Enrico Frigo
 *
 */
public class JemViewBroker {

	private static JemViewBroker INSTANCE = new JemViewBroker();
		
	private ArrayList<JemViewPart> views = new ArrayList<JemViewPart>();

	private String file=null;
	
	public static JemViewBroker getInstance(){
		return INSTANCE;
	}
	
	private JemViewBroker(){
	}
	
	public void register(JemViewPart jemViewPart){
		views.add(jemViewPart);
	}
	
	public ArrayList<JemViewPart> getRegisteredViews(){
		return views;
	}
	
	public void setImageAll(String file){
		setFile(file);
		Display.getDefault().asyncExec(new Runnable() {
			public void run() {
				for(int i=0;i<views.size();i++)
					views.get(i).setImage(getFile());
				setFile(null);
			}
		});
	}

	private void setFile(String file){
		this.file = file;
	}

	private String getFile(){
		return file;
	}
}
