/*******************************************************************************
 * Copyright (c) 2012-2013 pepstock.org.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors:
 *     Enrico - initial API and implementation
 ******************************************************************************/
package org.pepstock.jem.plugin.views;

import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;

/**
 * @author Andrea "Stock" Stocchero
 *
 */
public class ColumnSortListener implements SelectionListener {

	int index;

	private TableViewer viewer;

	/**
	 * @param column 
	 * @param viewer
	 */
	public ColumnSortListener(int column, JemViewPart viewer){
		this.viewer = (TableViewer)viewer.getViewer();
		index = column;
	}
	
	public ColumnSortListener(int column, TableViewer viewer){
		this.viewer = viewer;
		index = column;
	}

	public void widgetSelected(SelectionEvent e) {
		JobColumnSorter sorter = (JobColumnSorter)viewer.getSorter();
		
		if (sorter.getIndex() == index){
			boolean order = (sorter.isAscending()) ? false : true;
			sorter.setAscending(order);
		}
		else{
			sorter.setIndex(index);	
			sorter.setAscending(true);				
		}
		viewer.refresh();
	}

	public void widgetDefaultSelected(SelectionEvent e) {
	}

}
