/*******************************************************************************
 * Copyright (c) 2012-2013 pepstock.org.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors:
 *     Enrico - initial API and implementation
 ******************************************************************************/
package org.pepstock.jem.plugin.preferences;

import java.util.HashMap;
import java.util.Iterator;

import org.eclipse.equinox.security.storage.ISecurePreferences;
import org.eclipse.equinox.security.storage.SecurePreferencesFactory;
import org.eclipse.equinox.security.storage.StorageException;

import com.thoughtworks.xstream.XStream;

public class PreferenceManager {

	private static PreferenceManager INSTANCE = null;

	private final static XStream XS = new XStream();
	private ISecurePreferences preferences = SecurePreferencesFactory.getDefault();
	public final static String PREF_NODE_ENV = "envs";

	public static PreferenceManager getInstance(){
		return INSTANCE == null? INSTANCE = new PreferenceManager():INSTANCE;
	}
	
	public HashMap<String,Coordinate> loadPreferences() throws StorageException{
		HashMap<String,Coordinate> tableModel = new HashMap<String,Coordinate>();
		if(preferences.nodeExists(PREF_NODE_ENV)){
			ISecurePreferences envs = preferences.node(PREF_NODE_ENV);
			String[] keys = envs.keys();
			for (int i = 0; i < keys.length; i++) {
				String xml;
				try{
					xml = envs.get(keys[i],"n/a");
					Coordinate cc = (Coordinate)XS.fromXML(xml);
					tableModel.put(cc.getName(),cc);
				}catch(StorageException e){
					if(e.getErrorCode()==StorageException.NO_PASSWORD)
						return tableModel;
					throw e;
				}
			}
		}
		return tableModel;
	}
	
	public void storePreferences(HashMap<String,Coordinate> tableModel) throws StorageException{
		ISecurePreferences envs = preferences.node(PREF_NODE_ENV);
		envs.clear();
		for(Iterator<String> iterator = tableModel.keySet().iterator(); iterator.hasNext();){
			Coordinate cc = tableModel.get(iterator.next());
			String xml = XS.toXML(cc);
			envs.put(cc.getName(), xml, true);
		}

	}

}
